/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.whu;

import cn.edu.whu.CircRna;
import cn.edu.whu.CircView;
import cn.edu.whu.Gene;
import cn.edu.whu.GeneTranscript;
import cn.edu.whu.exception.FileReadException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;

public class CircRnaTool
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static boolean initSpeciesDataFromFile(File file, TreeMap<String, Gene> genes) {
        return CircRnaTool.parseGeneTranscriptFile(file, genes);
    }

    public static boolean initCircRnaDataFromFiles(Vector<Vector<String>> fileTableData, String speciesName, TreeMap<String, Gene> genes) throws FileReadException {
        return CircRnaTool.addCircRnaData(fileTableData, speciesName, genes);
    }

    private static boolean addCircRnaData(Vector<Vector<String>> fileTableData, String speciesName, TreeMap<String, Gene> genes) throws FileReadException {
        TreeMap<String, CircRna> circRnas = new TreeMap<String, CircRna>();
        for (Vector<String> rowData : fileTableData) {
            String species = rowData.get(0);
            if (!species.equalsIgnoreCase(speciesName)) continue;
            String toolName = rowData.get(1);
            String fileName = rowData.get(2);
            String filePath = rowData.get(3);
            String[] tmp = fileName.split("\\.");
            String sampleName = tmp[0];
            File file = new File(filePath);
            if (!(toolName.equalsIgnoreCase("circRNA_finder") || toolName.equalsIgnoreCase("find_circ") ? !CircRnaTool.parseCircRnaFinderFile(file, circRnas, sampleName, toolName, fileName) : (toolName.equalsIgnoreCase("CIRI") ? !CircRnaTool.parseCiriFile(file, circRnas, sampleName, toolName, fileName) : (toolName.equalsIgnoreCase("CIRCexplorer") ? !CircRnaTool.parseCircExplorerFile(file, circRnas, sampleName, toolName, fileName) : (toolName.equalsIgnoreCase("Mapsplice") ? !CircRnaTool.parseMapspliceFile(file, circRnas, sampleName, toolName, fileName) : (toolName.equalsIgnoreCase("UROBORUS") ? !CircRnaTool.parseUroborusFile(file, circRnas, sampleName, toolName, fileName) : !CircRnaTool.parseCircRnaFinderFile(file, circRnas, sampleName, toolName, fileName))))))) continue;
            throw new FileReadException("Can not open [" + file.getName() + "] or file FORMAT ERROR!");
        }
        CircView.log.info((Object)("Genes number: " + genes.size()));
        CircView.log.info((Object)("CircRNAs number: " + circRnas.size()));
        CircRnaTool.assignAll(genes, circRnas);
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean parseGeneTranscriptFile(File file, TreeMap<String, Gene> genes) {
        boolean ret = true;
        CircView.log.info((Object)("Parsing " + file.getName()));
        BufferedReader reader = null;
        try {
            if (file.isFile() && file.exists()) {
                reader = new BufferedReader(new FileReader(file));
                String lineTxt = null;
                int lineNum = 0;
                while ((lineTxt = reader.readLine()) != null) {
                    ++lineNum;
                    if (lineTxt.toLowerCase().contains("gene")) continue;
                    String[] parts = lineTxt.split("\t");
                    if (!parts[3].contains("+") && !parts[3].contains("-")) {
                        if (1 == lineNum) continue;
                        reader.close();
                        return false;
                    }
                    String geneName = parts[0];
                    GeneTranscript geneTranscript = new GeneTranscript(geneName);
                    geneTranscript.setTranscriptName(parts[1]);
                    geneTranscript.setChrom(parts[2]);
                    geneTranscript.setStrand(parts[3]);
                    geneTranscript.setTxStart(Long.parseLong(parts[4]));
                    geneTranscript.setTxEnd(Long.parseLong(parts[5]));
                    geneTranscript.setCdsStart(Long.parseLong(parts[6]));
                    geneTranscript.setCdsEnd(Long.parseLong(parts[7]));
                    geneTranscript.setExonCount(Integer.parseInt(parts[8]));
                    String[] exonStarts = parts[9].split(",");
                    int i = 0;
                    while (i < exonStarts.length) {
                        geneTranscript.getExonStarts().addElement(Long.parseLong(exonStarts[i]));
                        ++i;
                    }
                    String[] exonEnds = parts[10].split(",");
                    int i2 = 0;
                    while (i2 < exonEnds.length) {
                        geneTranscript.getExonEnds().addElement(Long.parseLong(exonEnds[i2]));
                        ++i2;
                    }
                    if (genes.containsKey(geneName.toUpperCase())) {
                        genes.get(geneName.toUpperCase()).getGeneTranscripts().put(geneTranscript.getTranscriptName(), geneTranscript);
                        continue;
                    }
                    Gene gene = new Gene(geneName);
                    gene.getGeneTranscripts().put(geneTranscript.getTranscriptName(), geneTranscript);
                    genes.put(geneName.toUpperCase(), gene);
                }
                reader.close();
            } else {
                ret = false;
                CircView.log.info((Object)("Can't open the file: " + file.getName()));
            }
        }
        catch (Exception e) {
            ret = false;
            CircView.log.warn((Object)e.getMessage());
        }
        return ret;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean parseCircRnaFinderFile(File file, TreeMap<String, CircRna> circRnas, String sampleName, String circTool, String fileName) {
        boolean ret = true;
        CircView.log.info((Object)("Parsing " + file.getName()));
        BufferedReader reader = null;
        try {
            if (file.isFile() && file.exists()) {
                reader = new BufferedReader(new FileReader(file));
                String lineTxt = null;
                int lineNum = 0;
                while ((lineTxt = reader.readLine()) != null) {
                    ++lineNum;
                    if (lineTxt.toLowerCase().contains("strand")) continue;
                    String[] parts = lineTxt.split("\t");
                    if (!parts[5].contains("+") && !parts[5].contains("-")) {
                        if (1 == lineNum) continue;
                        reader.close();
                        return false;
                    }
                    String circRnaId = String.valueOf(parts[0]) + ":" + parts[1] + "|" + parts[2];
                    CircRna circRna = new CircRna(circRnaId);
                    circRna.setChrom(parts[0]);
                    circRna.setStartPoint(Long.parseLong(parts[1]));
                    circRna.setEndPoint(Long.parseLong(parts[2]));
                    circRna.setJunctionReads((int)Long.parseLong(parts[4]));
                    circRna.setStrand(parts[5]);
                    if (circRnas.containsKey(circRnaId.toUpperCase())) {
                        if (circRnas.get(circRnaId.toUpperCase()).getSamples().get(sampleName) != null) {
                            circRnas.get(circRnaId.toUpperCase()).getSamples().put(sampleName, circRnas.get(circRnaId.toUpperCase()).getSamples().get(sampleName) + 1);
                        } else {
                            circRnas.get(circRnaId.toUpperCase()).getSamples().put(sampleName, 1);
                        }
                        if (circRnas.get(circRnaId.toUpperCase()).getCircTools().get(circTool) != null) {
                            circRnas.get(circRnaId.toUpperCase()).getCircTools().put(circTool, circRnas.get(circRnaId.toUpperCase()).getCircTools().get(circTool) + 1);
                        } else {
                            circRnas.get(circRnaId.toUpperCase()).getCircTools().put(circTool, 1);
                        }
                        if (circRnas.get(circRnaId.toUpperCase()).getFiles().get(fileName) != null) {
                            circRnas.get(circRnaId.toUpperCase()).getFiles().put(fileName, circRnas.get(circRnaId.toUpperCase()).getFiles().get(fileName) + 1);
                        } else {
                            circRnas.get(circRnaId.toUpperCase()).getFiles().put(fileName, 1);
                        }
                        if (circRna.getJunctionReads() <= circRnas.get(circRnaId.toUpperCase()).getJunctionReads()) continue;
                        circRnas.get(circRnaId.toUpperCase()).setJunctionReads(circRna.getJunctionReads());
                        continue;
                    }
                    circRna.getSamples().put(sampleName, 1);
                    circRna.getCircTools().put(circTool, 1);
                    circRna.getFiles().put(fileName, 1);
                    circRnas.put(circRnaId.toUpperCase(), circRna);
                }
                reader.close();
            } else {
                CircView.log.warn((Object)("Can't find the file: " + file.getName()));
            }
        }
        catch (Exception e) {
            CircView.log.warn((Object)e.getMessage());
            ret = false;
        }
        return ret;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean parseCircExplorerFile(File file, TreeMap<String, CircRna> circRnas, String sampleName, String circTool, String fileName) {
        boolean ret = true;
        CircView.log.info((Object)("Parsing " + file.getName()));
        BufferedReader reader = null;
        try {
            if (file.isFile() && file.exists()) {
                reader = new BufferedReader(new FileReader(file));
                String lineTxt = null;
                int lineNum = 0;
                while ((lineTxt = reader.readLine()) != null) {
                    ++lineNum;
                    String[] parts = lineTxt.split("\t");
                    if (!parts[5].contains("+") && !parts[5].contains("-")) {
                        if (1 == lineNum) continue;
                        reader.close();
                        return false;
                    }
                    String circRnaId = String.valueOf(parts[0]) + ":" + parts[1] + "|" + parts[2];
                    CircRna circRna = new CircRna(circRnaId);
                    circRna.setChrom(parts[0]);
                    circRna.setStartPoint(Long.parseLong(parts[1]));
                    circRna.setEndPoint(Long.parseLong(parts[2]));
                    String tmp = parts[3];
                    String[] junc = tmp.split("/");
                    circRna.setJunctionReads((int)Long.parseLong(junc[1]));
                    circRna.setStrand(parts[5]);
                    if (circRnas.containsKey(circRnaId.toUpperCase())) {
                        if (circRnas.get(circRnaId.toUpperCase()).getSamples().get(sampleName) != null) {
                            circRnas.get(circRnaId.toUpperCase()).getSamples().put(sampleName, circRnas.get(circRnaId.toUpperCase()).getSamples().get(sampleName) + 1);
                        } else {
                            circRnas.get(circRnaId.toUpperCase()).getSamples().put(sampleName, 1);
                        }
                        if (circRnas.get(circRnaId.toUpperCase()).getCircTools().get(circTool) != null) {
                            circRnas.get(circRnaId.toUpperCase()).getCircTools().put(circTool, circRnas.get(circRnaId.toUpperCase()).getCircTools().get(circTool) + 1);
                        } else {
                            circRnas.get(circRnaId.toUpperCase()).getCircTools().put(circTool, 1);
                        }
                        if (circRnas.get(circRnaId.toUpperCase()).getFiles().get(fileName) != null) {
                            circRnas.get(circRnaId.toUpperCase()).getFiles().put(fileName, circRnas.get(circRnaId.toUpperCase()).getFiles().get(fileName) + 1);
                        } else {
                            circRnas.get(circRnaId.toUpperCase()).getFiles().put(fileName, 1);
                        }
                        if (circRna.getJunctionReads() <= circRnas.get(circRnaId.toUpperCase()).getJunctionReads()) continue;
                        circRnas.get(circRnaId.toUpperCase()).setJunctionReads(circRna.getJunctionReads());
                        continue;
                    }
                    circRna.getSamples().put(sampleName, 1);
                    circRna.getCircTools().put(circTool, 1);
                    circRna.getFiles().put(fileName, 1);
                    circRnas.put(circRnaId.toUpperCase(), circRna);
                }
                reader.close();
            } else {
                CircView.log.warn((Object)("Can't find the file: " + file.getName()));
            }
        }
        catch (Exception e) {
            CircView.log.warn((Object)e.getMessage());
            ret = false;
        }
        return ret;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean parseCiriFile(File file, TreeMap<String, CircRna> circRnas, String sampleName, String circTool, String fileName) {
        boolean ret = true;
        CircView.log.info((Object)("Parsing " + file.getName()));
        BufferedReader reader = null;
        try {
            if (file.isFile() && file.exists()) {
                reader = new BufferedReader(new FileReader(file));
                String lineTxt = null;
                int lineNum = 0;
                while ((lineTxt = reader.readLine()) != null) {
                    ++lineNum;
                    String[] parts = lineTxt.split("\t");
                    if (!parts[10].contains("+") && !parts[10].contains("-")) {
                        if (1 == lineNum) continue;
                        reader.close();
                        return false;
                    }
                    String circRnaId = parts[0];
                    CircRna circRna = new CircRna(circRnaId);
                    circRna.setChrom(parts[1]);
                    circRna.setStartPoint(Long.parseLong(parts[2]));
                    circRna.setEndPoint(Long.parseLong(parts[3]));
                    circRna.setJunctionReads((int)Long.parseLong(parts[4]));
                    circRna.setStrand(parts[10]);
                    if (circRnas.containsKey(circRnaId.toUpperCase())) {
                        if (circRnas.get(circRnaId.toUpperCase()).getSamples().get(sampleName) != null) {
                            circRnas.get(circRnaId.toUpperCase()).getSamples().put(sampleName, circRnas.get(circRnaId.toUpperCase()).getSamples().get(sampleName) + 1);
                        } else {
                            circRnas.get(circRnaId.toUpperCase()).getSamples().put(sampleName, 1);
                        }
                        if (circRnas.get(circRnaId.toUpperCase()).getCircTools().get(circTool) != null) {
                            circRnas.get(circRnaId.toUpperCase()).getCircTools().put(circTool, circRnas.get(circRnaId.toUpperCase()).getCircTools().get(circTool) + 1);
                        } else {
                            circRnas.get(circRnaId.toUpperCase()).getCircTools().put(circTool, 1);
                        }
                        if (circRnas.get(circRnaId.toUpperCase()).getFiles().get(fileName) != null) {
                            circRnas.get(circRnaId.toUpperCase()).getFiles().put(fileName, circRnas.get(circRnaId.toUpperCase()).getFiles().get(fileName) + 1);
                        } else {
                            circRnas.get(circRnaId.toUpperCase()).getFiles().put(fileName, 1);
                        }
                        if (circRna.getJunctionReads() <= circRnas.get(circRnaId.toUpperCase()).getJunctionReads()) continue;
                        circRnas.get(circRnaId.toUpperCase()).setJunctionReads(circRna.getJunctionReads());
                        continue;
                    }
                    circRna.getSamples().put(sampleName, 1);
                    circRna.getCircTools().put(circTool, 1);
                    circRna.getFiles().put(fileName, 1);
                    circRnas.put(circRnaId.toUpperCase(), circRna);
                }
                reader.close();
            } else {
                CircView.log.warn((Object)("Can't find the file: " + file.getName()));
                ret = false;
            }
        }
        catch (Exception e) {
            CircView.log.warn((Object)e.getMessage());
            ret = false;
        }
        return ret;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean parseMapspliceFile(File file, TreeMap<String, CircRna> circRnas, String sampleName, String circTool, String fileName) {
        boolean ret = true;
        CircView.log.info((Object)("Parsing " + file.getName()));
        BufferedReader reader = null;
        try {
            if (file.isFile() && file.exists()) {
                reader = new BufferedReader(new FileReader(file));
                String lineTxt = null;
                int lineNum = 0;
                while ((lineTxt = reader.readLine()) != null) {
                    ++lineNum;
                    if (lineTxt.toLowerCase().contains("circ")) continue;
                    String[] parts = lineTxt.split("\t");
                    if (!parts[5].contains("+") && !parts[5].contains("-")) {
                        if (1 == lineNum) continue;
                        reader.close();
                        return false;
                    }
                    String[] tmp = parts[0].split("~");
                    String chr = tmp[0];
                    String circRnaId = String.valueOf(chr) + ":" + parts[1] + "|" + parts[2];
                    CircRna circRna = new CircRna(circRnaId);
                    circRna.setChrom(chr);
                    circRna.setStartPoint(Long.parseLong(parts[1]));
                    circRna.setEndPoint(Long.parseLong(parts[2]));
                    circRna.setStrand(parts[5].substring(0, 1));
                    circRna.setJunctionReads((int)Long.parseLong(parts[4]));
                    if (circRnas.containsKey(circRnaId.toUpperCase())) {
                        if (circRnas.get(circRnaId.toUpperCase()).getSamples().get(sampleName) != null) {
                            circRnas.get(circRnaId.toUpperCase()).getSamples().put(sampleName, circRnas.get(circRnaId.toUpperCase()).getSamples().get(sampleName) + 1);
                        } else {
                            circRnas.get(circRnaId.toUpperCase()).getSamples().put(sampleName, 1);
                        }
                        if (circRnas.get(circRnaId.toUpperCase()).getCircTools().get(circTool) != null) {
                            circRnas.get(circRnaId.toUpperCase()).getCircTools().put(circTool, circRnas.get(circRnaId.toUpperCase()).getCircTools().get(circTool) + 1);
                        } else {
                            circRnas.get(circRnaId.toUpperCase()).getCircTools().put(circTool, 1);
                        }
                        if (circRnas.get(circRnaId.toUpperCase()).getFiles().get(fileName) != null) {
                            circRnas.get(circRnaId.toUpperCase()).getFiles().put(fileName, circRnas.get(circRnaId.toUpperCase()).getFiles().get(fileName) + 1);
                        } else {
                            circRnas.get(circRnaId.toUpperCase()).getFiles().put(fileName, 1);
                        }
                        if (circRna.getJunctionReads() <= circRnas.get(circRnaId.toUpperCase()).getJunctionReads()) continue;
                        circRnas.get(circRnaId.toUpperCase()).setJunctionReads(circRna.getJunctionReads());
                        continue;
                    }
                    circRna.getSamples().put(sampleName, 1);
                    circRna.getCircTools().put(circTool, 1);
                    circRna.getFiles().put(fileName, 1);
                    circRnas.put(circRnaId.toUpperCase(), circRna);
                }
                reader.close();
            } else {
                CircView.log.warn((Object)("Can't find the file: " + file.getName()));
            }
        }
        catch (Exception e) {
            CircView.log.warn((Object)e.getMessage());
            ret = false;
        }
        return ret;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean parseUroborusFile(File file, TreeMap<String, CircRna> circRnas, String sampleName, String circTool, String fileName) {
        boolean ret = true;
        CircView.log.info((Object)("Parsing " + file.getName()));
        BufferedReader reader = null;
        try {
            if (file.isFile() && file.exists()) {
                reader = new BufferedReader(new FileReader(file));
                String lineTxt = null;
                int lineNum = 0;
                while ((lineTxt = reader.readLine()) != null) {
                    ++lineNum;
                    if (lineTxt.toLowerCase().contains("circ")) continue;
                    String[] parts = lineTxt.split("\t");
                    if (!parts[3].contains("+") && !parts[3].contains("-")) {
                        if (1 == lineNum) continue;
                        reader.close();
                        return false;
                    }
                    String circRnaId = String.valueOf(parts[0]) + ":" + parts[1] + "|" + parts[2];
                    CircRna circRna = new CircRna(circRnaId);
                    circRna.setChrom(parts[0]);
                    circRna.setStartPoint(Long.parseLong(parts[1]));
                    circRna.setEndPoint(Long.parseLong(parts[2]));
                    circRna.setStrand(parts[3]);
                    circRna.setJunctionReads((int)Long.parseLong(parts[6]));
                    if (circRnas.containsKey(circRnaId.toUpperCase())) {
                        if (circRnas.get(circRnaId.toUpperCase()).getSamples().get(sampleName) != null) {
                            circRnas.get(circRnaId.toUpperCase()).getSamples().put(sampleName, circRnas.get(circRnaId.toUpperCase()).getSamples().get(sampleName) + 1);
                        } else {
                            circRnas.get(circRnaId.toUpperCase()).getSamples().put(sampleName, 1);
                        }
                        if (circRnas.get(circRnaId.toUpperCase()).getCircTools().get(circTool) != null) {
                            circRnas.get(circRnaId.toUpperCase()).getCircTools().put(circTool, circRnas.get(circRnaId.toUpperCase()).getCircTools().get(circTool) + 1);
                        } else {
                            circRnas.get(circRnaId.toUpperCase()).getCircTools().put(circTool, 1);
                        }
                        if (circRnas.get(circRnaId.toUpperCase()).getFiles().get(fileName) != null) {
                            circRnas.get(circRnaId.toUpperCase()).getFiles().put(fileName, circRnas.get(circRnaId.toUpperCase()).getFiles().get(fileName) + 1);
                        } else {
                            circRnas.get(circRnaId.toUpperCase()).getFiles().put(fileName, 1);
                        }
                        if (circRna.getJunctionReads() <= circRnas.get(circRnaId.toUpperCase()).getJunctionReads()) continue;
                        circRnas.get(circRnaId.toUpperCase()).setJunctionReads(circRna.getJunctionReads());
                        continue;
                    }
                    circRna.getSamples().put(sampleName, 1);
                    circRna.getCircTools().put(circTool, 1);
                    circRna.getFiles().put(fileName, 1);
                    circRnas.put(circRnaId.toUpperCase(), circRna);
                }
                reader.close();
            } else {
                CircView.log.warn((Object)("Can't find the file: " + file.getName()));
            }
        }
        catch (Exception e) {
            CircView.log.warn((Object)e.getMessage());
            ret = false;
        }
        return ret;
    }

    private static void preAssign(TreeMap<String, Gene> allGene, TreeMap<String, ArrayList<Long>> txStartMap, TreeMap<String, ArrayList<Long>> txEndMap, TreeMap<Long, TreeMap<String, String>> txStart2Name, TreeMap<Long, TreeMap<String, String>> txEnd2Name) {
        txStartMap.clear();
        txEndMap.clear();
        txStart2Name.clear();
        txEnd2Name.clear();
        for (String geneName : allGene.keySet()) {
            String chrom = "";
            TreeMap<Long, Integer> tmpUniqueStart = new TreeMap<Long, Integer>();
            TreeMap<Long, Integer> tmpUniqueEnd = new TreeMap<Long, Integer>();
            TreeMap<String, GeneTranscript> transcripts = allGene.get(geneName.toUpperCase()).getGeneTranscripts();
            for (String transcriptName : transcripts.keySet()) {
                TreeMap<Object, Object> genesTmp;
                GeneTranscript transcript = transcripts.get(transcriptName);
                chrom = transcript.getChrom();
                Long txStart = transcript.getTxStart();
                Long txEnd = transcript.getTxEnd();
                if (txStart2Name.get(txStart) != null) {
                    genesTmp = txStart2Name.get(txStart);
                    genesTmp.put(geneName, geneName);
                    txStart2Name.put(txStart, genesTmp);
                } else {
                    genesTmp = new TreeMap();
                    genesTmp.put(geneName, geneName);
                    txStart2Name.put(txStart, genesTmp);
                }
                if (txEnd2Name.get(txEnd) != null) {
                    genesTmp = txEnd2Name.get(txEnd);
                    genesTmp.put(geneName, geneName);
                    txEnd2Name.put(txEnd, genesTmp);
                } else {
                    genesTmp = new TreeMap();
                    genesTmp.put(geneName, geneName);
                    txEnd2Name.put(txEnd, genesTmp);
                }
                tmpUniqueStart.put(txStart, 1);
                tmpUniqueEnd.put(txEnd, 1);
            }
            ArrayList<Long> uniqueStartList = new ArrayList<Long>();
            ArrayList<Long> uniqueEndList = new ArrayList<Long>();
            for (Long txStart : tmpUniqueStart.keySet()) {
                uniqueStartList.add(txStart);
            }
            for (Long txEnd : tmpUniqueEnd.keySet()) {
                uniqueEndList.add(txEnd);
            }
            if (txStartMap.get(chrom) != null) {
                txStartMap.get(chrom).addAll(uniqueStartList);
            } else {
                txStartMap.put(chrom, uniqueStartList);
            }
            if (txEndMap.get(chrom) != null) {
                txEndMap.get(chrom).addAll(uniqueEndList);
                continue;
            }
            txEndMap.put(chrom, uniqueEndList);
        }
        for (String chr : txStartMap.keySet()) {
            Collections.sort((List)txStartMap.get(chr));
        }
        for (String chr : txEndMap.keySet()) {
            Collections.sort((List)txEndMap.get(chr));
        }
    }

    private static void assign(CircRna circRna, TreeMap<String, Gene> allGene, TreeMap<String, ArrayList<Long>> chr2StartList, TreeMap<String, ArrayList<Long>> chr2EndList, TreeMap<Long, TreeMap<String, String>> txStart2Name, TreeMap<Long, TreeMap<String, String>> txEnd2Name) {
        int index;
        String chrom = circRna.getChrom();
        Long startPoint = circRna.getStartPoint();
        Long endPoint = circRna.getEndPoint();
        ArrayList<Long> txStartList = chr2StartList.get(chrom);
        if (txStartList == null) {
            CircView.log.info((Object)("circRNA_ID [" + circRna.getCircRnaID() + "] can not find related chrom"));
            return;
        }
        ArrayList<Long> txEndList = chr2EndList.get(chrom);
        if (txEndList == null) {
            CircView.log.info((Object)("circRNA_ID [" + circRna.getCircRnaID() + "] can not find related chrom"));
            return;
        }
        int indexByTxStart = CircRnaTool.splitHalfByTxStart(txStartList, (long)startPoint, 0, txStartList.size() - 1);
        indexByTxStart = indexByTxStart < 0 ? 0 : indexByTxStart;
        indexByTxStart = indexByTxStart > txStartList.size() - 1 ? txStartList.size() - 1 : indexByTxStart;
        int indexByTxEnd = CircRnaTool.splitHalfByTxEnd(txEndList, (long)endPoint, 0, txEndList.size() - 1);
        indexByTxEnd = indexByTxEnd <= 1 ? 0 : indexByTxEnd;
        indexByTxEnd = indexByTxEnd > txEndList.size() - 1 ? txEndList.size() - 1 : indexByTxEnd;
        TreeMap<String, Integer> geneNames = new TreeMap<String, Integer>();
        if (indexByTxStart + 1 < txEndList.size() - indexByTxEnd) {
            index = 0;
            while (index <= indexByTxStart) {
                for (String name : txStart2Name.get(txStartList.get(index)).keySet()) {
                    geneNames.put(name, 1);
                }
                ++index;
            }
        } else {
            index = indexByTxEnd;
            while (index < txEndList.size()) {
                for (String name : txEnd2Name.get(txEndList.get(index)).keySet()) {
                    geneNames.put(name, 1);
                }
                ++index;
            }
        }
        TreeMap<String, Integer> geneLocation = new TreeMap<String, Integer>();
        TreeMap<String, Integer> region = new TreeMap<String, Integer>();
        int exonSign = 0;
        for (String name : geneNames.keySet()) {
            int geneLocationSign = 0;
            int mRnaSign = 0;
            int lncRnaSign = 0;
            Gene gene = allGene.get(name.toUpperCase());
            if (gene == null) {
                return;
            }
            TreeMap<String, GeneTranscript> transcripts = gene.getGeneTranscripts();
            for (String transcriptName : transcripts.keySet()) {
                GeneTranscript trans = transcripts.get(transcriptName);
                if (trans.getTxStart() <= startPoint && endPoint <= trans.getTxEnd()) {
                    ++geneLocationSign;
                    geneLocation.put(String.valueOf(name) + " " + trans.getTranscriptName(), 1);
                    if (trans.getCircRnas().get(circRna.getCircRnaID()) == null) {
                        trans.getCircRnas().put(circRna.getCircRnaID(), circRna);
                    }
                    int repeat = 0;
                    for (String fileName : circRna.getFiles().keySet()) {
                        repeat += circRna.getFiles().get(fileName).intValue();
                    }
                    trans.getCircRnasNum().put(circRna.getCircRnaID(), repeat);
                    trans.setTotalJunctionReads(trans.getTotalJunctionReads() + circRna.getJunctionReads());
                }
                if (trans.getCdsStart() < trans.getCdsEnd()) {
                    ++mRnaSign;
                } else {
                    ++lncRnaSign;
                }
                int i = 0;
                while (i < trans.getExonCount()) {
                    Long exonStart = trans.getExonStarts().get(i);
                    Long exonEnd = trans.getExonEnds().get(i);
                    if (exonStart - 2L <= startPoint && startPoint < exonEnd + 2L || exonStart - 2L < endPoint && endPoint <= exonEnd + 2L || startPoint < exonStart - 2L && exonEnd < endPoint + 2L) {
                        ++exonSign;
                    }
                    ++i;
                }
            }
            if (geneLocationSign <= 0) continue;
            if (mRnaSign > 0) {
                region.put("mRNA", 1);
                continue;
            }
            region.put("lncRNA", 1);
        }
        if (geneLocation.size() > 0) {
            for (String n : geneLocation.keySet()) {
                circRna.getGeneTranscrpits().put(n, n);
            }
            if (exonSign > 0) {
                circRna.setCircRnaType("exon");
            } else {
                circRna.setCircRnaType("intron");
            }
            if (region.get("mRNA") != null && region.get("lncRNA") == null) {
                circRna.setRegion("mRNA");
            } else if (region.get("mRNA") == null && region.get("lncRNA") != null) {
                circRna.setRegion("lncRNA");
            }
            if (region.get("mRNA") != null && region.get("lncRNA") != null) {
                circRna.setRegion("mRNA,lncRNA");
            }
        } else {
            circRna.getGeneTranscrpits().put("n/a", "n/a");
            circRna.setCircRnaType("intergenic");
            circRna.setRegion("Unknown");
        }
    }

    private static void assignAll(TreeMap<String, Gene> allGene, TreeMap<String, CircRna> allCircRna) {
        TreeMap<String, ArrayList<Long>> chr2StartList = new TreeMap<String, ArrayList<Long>>();
        TreeMap<String, ArrayList<Long>> chr2EndList = new TreeMap<String, ArrayList<Long>>();
        TreeMap<Long, TreeMap<String, String>> txStart2Name = new TreeMap<Long, TreeMap<String, String>>();
        TreeMap<Long, TreeMap<String, String>> txEnd2Name = new TreeMap<Long, TreeMap<String, String>>();
        if (allGene != null && allCircRna != null) {
            CircRnaTool.preAssign(allGene, chr2StartList, chr2EndList, txStart2Name, txEnd2Name);
        }
        int num = 0;
        for (String circRnaId : allCircRna.keySet()) {
            if (++num % 1000 == 0) {
                CircView.log.info((Object)("Mapping: [" + num + "|" + allCircRna.size() + "]"));
            }
            CircRna circRna = allCircRna.get(circRnaId);
            CircRnaTool.assign(circRna, allGene, chr2StartList, chr2EndList, txStart2Name, txEnd2Name);
        }
    }

    private static int splitHalfByTxStart(ArrayList<Long> arrayData, Long txStart, int start, int end) {
        int index = (start + end) / 2;
        Long data = arrayData.get(index);
        if (start > end) {
            return end;
        }
        if (data.longValue() == txStart.longValue()) {
            return index;
        }
        if (data < txStart) {
            return CircRnaTool.splitHalfByTxStart(arrayData, txStart, index + 1, end);
        }
        return CircRnaTool.splitHalfByTxStart(arrayData, txStart, start, index - 1);
    }

    private static int splitHalfByTxEnd(ArrayList<Long> arrayData, Long txEnd, int start, int end) {
        int index = (start + end) / 2;
        Long data = arrayData.get(index);
        if (start > end) {
            return start;
        }
        if (data.longValue() == txEnd.longValue()) {
            return index;
        }
        if (data < txEnd) {
            return CircRnaTool.splitHalfByTxEnd(arrayData, txEnd, index + 1, end);
        }
        return CircRnaTool.splitHalfByTxEnd(arrayData, txEnd, start, index - 1);
    }
}

