/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.whu;

import cn.edu.whu.CircRna;
import cn.edu.whu.Gene;
import cn.edu.whu.GeneTranscript;
import cn.edu.whu.MainData;
import cn.edu.whu.ui.AboutDialog;
import cn.edu.whu.ui.CircRnaDataClearDialog;
import cn.edu.whu.ui.CircRnaDataLoadDialog;
import cn.edu.whu.ui.CircRnaImagePanel;
import cn.edu.whu.ui.CircRnaToolAddDialog;
import cn.edu.whu.ui.CircRnaToolDelDialog;
import cn.edu.whu.ui.ComparisonFrame;
import cn.edu.whu.ui.DataLoadingDialog;
import cn.edu.whu.ui.DetailsResultDialog;
import cn.edu.whu.ui.MreClearDialog;
import cn.edu.whu.ui.MreLoadDialog;
import cn.edu.whu.ui.RbpClearDialog;
import cn.edu.whu.ui.RbpLoadDialog;
import cn.edu.whu.ui.SaveImageDialog;
import cn.edu.whu.ui.SpeciesAddDialog;
import cn.edu.whu.ui.SpeciesDelDialog;
import cn.edu.whu.util.DbUtil;
import cn.edu.whu.util.RuntimeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class CircView {
    public static JFrame frame;
    private JPanel imagePanel;
    private static JComboBox<String> cbSpecies;
    private static JComboBox<String> cbCircRnaTool;
    private static JComboBox<String> cbSample;
    private static JComboBox<String> cbChrom;
    private static Vector<String> geneTransName;
    private static JList<String> geneTransList;
    private static JComboBox<String> cbCircRnaSelect;
    private CircRnaImagePanel circRnaImage;
    private static JCheckBox cbRbp;
    private static JCheckBox cbMre;
    private static Connection conn;
    public static Logger log;
    private static TreeMap<String, Gene> genes;
    private boolean cbChromInit;
    private static JTextArea tipsTA;

    public static void main(String[] args) {
        CircView.initLogConfig("log4j.properties");
        log = Logger.getLogger(CircView.class);
        PropertyConfigurator.configure((String)"log4j.properties");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    long mem = RuntimeUtils.getAvailableMemory();
                    int MB = 1000000;
                    if (mem < (long)(400 * MB)) {
                        int mb = (int)(mem / (long)MB);
                        JOptionPane.showMessageDialog(null, "Warning: CircView is running with low available memory (" + mb + " mb)");
                    }
                    new CircView();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void initLogConfig(String logFile) {
        File file = new File("log4j.properties");
        if (!file.exists()) {
            Properties logPro = new Properties();
            try {
                logPro.setProperty("log4j.rootLogger", "INFO,Console,File");
                logPro.setProperty("log4j.appender.Console", "org.apache.log4j.ConsoleAppender");
                logPro.setProperty("log4j.appender.Console.Target", "System.out");
                logPro.setProperty("log4j.appender.Console.layout", "org.apache.log4j.PatternLayout");
                logPro.setProperty("log4j.appender.Console.layout.ConversionPattern", "[%c] - %m%n");
                logPro.setProperty("log4j.appender.File", "org.apache.log4j.RollingFileAppender");
                logPro.setProperty("log4j.appender.File.File", "logs/circview.log");
                logPro.setProperty("log4j.appender.File.MaxFileSize", "10MB");
                logPro.setProperty("log4j.appender.File.Threshold", "ALL");
                logPro.setProperty("log4j.appender.File.layout", "org.apache.log4j.PatternLayout");
                logPro.setProperty("log4j.appender.File.layout.ConversionPattern", "[%p] [%d{yyyy-MM-dd HH:mm:ss}][%c]%m%n");
                FileOutputStream os = new FileOutputStream("log4j.properties");
                logPro.store(os, "Save LogConfig File");
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
            }
        }
    }

    public CircView() {
        this.initData();
        this.connectDB();
        this.initInterface();
        frame.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                CircView.this.display();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    private void initData() {
        new MainData();
        geneTransName = new Vector();
    }

    private void initInterface() {
        this.cbChromInit = true;
        this.initComponent();
        this.initFrame();
        this.initMenu();
        this.initToolBar();
        this.initMainPanel();
    }

    private void initComponent() {
        frame = new JFrame("CircRNA Viewer");
        cbSpecies = new JComboBox();
        cbCircRnaTool = new JComboBox();
        cbSample = new JComboBox();
        cbChrom = new JComboBox();
        geneTransList = new JList();
    }

    private void connectDB() {
        try {
            conn = DbUtil.connectDb();
            DbUtil.createDb(conn);
        }
        catch (ClassNotFoundException | SQLException e) {
            log.warn((Object)e.getMessage());
        }
        try {
            DbUtil.useDb(conn);
        }
        catch (ClassNotFoundException | SQLException e) {
            log.warn((Object)e.getMessage());
        }
    }

    private void initFrame() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setBounds(0, 0, (int)screenSize.getWidth(), (int)screenSize.getHeight());
        frame.setMinimumSize(new Dimension(800, 600));
        frame.setDefaultCloseOperation(3);
    }

    private void initMenu() {
        JMenuBar menuBar = new JMenuBar();
        frame.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu("File");
        JMenu mnCircRna = new JMenu("CircRNA");
        JMenu mnAnalysis = new JMenu("Analysis");
        JMenu mnSpecies = new JMenu("Species");
        JMenu mnDbLink = new JMenu("Database");
        JMenu mnMre = new JMenu("MRE");
        JMenu mnRbp = new JMenu("RBP");
        JMenu mnHelp = new JMenu("Help");
        menuBar.add(mnFile);
        menuBar.add(mnCircRna);
        menuBar.add(mnAnalysis);
        menuBar.add(mnSpecies);
        menuBar.add(mnDbLink);
        menuBar.add(mnMre);
        menuBar.add(mnRbp);
        menuBar.add(mnHelp);
        JMenuItem mntmQuit = new JMenuItem("Quit");
        mnFile.add(mntmQuit);
        JMenuItem mntmCircRnaLoad = new JMenuItem("Load Data");
        JMenuItem mntmCircRnaClear = new JMenuItem("Clear Data");
        JMenuItem mntmCircRnaAdd = new JMenuItem("Add Tool");
        JMenuItem mntmCircRnaDel = new JMenuItem("Delete Tool");
        mnCircRna.add(mntmCircRnaLoad);
        mnCircRna.add(mntmCircRnaClear);
        mnCircRna.addSeparator();
        mnCircRna.add(mntmCircRnaAdd);
        mnCircRna.add(mntmCircRnaDel);
        JMenuItem mntmCompare = new JMenuItem("Comparison");
        mnAnalysis.add(mntmCompare);
        JMenuItem mntmSpeciesAdd = new JMenuItem("Add Species");
        JMenuItem mntmSpeciesDel = new JMenuItem("Delete Species");
        mnSpecies.add(mntmSpeciesAdd);
        mnSpecies.add(mntmSpeciesDel);
        JMenuItem mntmMreLoad = new JMenuItem("Load Data");
        JMenuItem mntmMreClear = new JMenuItem("Clear");
        mnMre.add(mntmMreLoad);
        mnMre.add(mntmMreClear);
        JMenuItem mntmRbpLoad = new JMenuItem("Load Data");
        JMenuItem mntmRbpClear = new JMenuItem("Clear");
        mnRbp.add(mntmRbpLoad);
        mnRbp.add(mntmRbpClear);
        JMenuItem mntmLink1 = new JMenuItem("Circ2Traits");
        JMenuItem mntmLink2 = new JMenuItem("CircBase");
        JMenuItem mntmLink3 = new JMenuItem("CircInteractome");
        JMenuItem mntmLink4 = new JMenuItem("CircNet");
        JMenuItem mntmLink5 = new JMenuItem("CircRNADb");
        JMenuItem mntmLink6 = new JMenuItem("StarBase");
        JMenuItem mntmLink7 = new JMenuItem("TSCD");
        mnDbLink.add(mntmLink1);
        mnDbLink.add(mntmLink2);
        mnDbLink.add(mntmLink3);
        mnDbLink.add(mntmLink4);
        mnDbLink.add(mntmLink5);
        mnDbLink.add(mntmLink6);
        mnDbLink.add(mntmLink7);
        JMenuItem mntmAbout = new JMenuItem("About");
        mnHelp.add(mntmAbout);
        if (conn == null) {
            mntmRbpLoad.setEnabled(false);
            mntmRbpClear.setEnabled(false);
            mntmMreLoad.setEnabled(false);
            mntmMreClear.setEnabled(false);
        }
        mntmQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        mntmCircRnaLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new CircRnaDataLoadDialog();
            }
        });
        mntmCircRnaClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new CircRnaDataClearDialog();
            }
        });
        mntmCircRnaAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new CircRnaToolAddDialog();
            }
        });
        mntmCircRnaDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new CircRnaToolDelDialog();
            }
        });
        mntmCompare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ComparisonFrame();
            }
        });
        mntmSpeciesAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SpeciesAddDialog();
            }
        });
        mntmSpeciesDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SpeciesDelDialog();
            }
        });
        mntmMreLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new MreLoadDialog(conn);
            }
        });
        mntmMreClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new MreClearDialog(conn);
            }
        });
        mntmRbpLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new RbpLoadDialog(conn);
            }
        });
        mntmRbpClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new RbpClearDialog(conn);
            }
        });
        mntmLink1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URI uri = new URI("http://gyanxet-beta.com/circdb/");
                    Desktop dtp = Desktop.getDesktop();
                    if (Desktop.isDesktopSupported() && dtp.isSupported(Desktop.Action.BROWSE)) {
                        dtp.browse(uri);
                    }
                }
                catch (IOException | URISyntaxException e1) {
                    log.warn((Object)e1.getMessage());
                }
            }
        });
        mntmLink2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URI uri = new URI("http://circbase.org");
                    Desktop dtp = Desktop.getDesktop();
                    if (Desktop.isDesktopSupported() && dtp.isSupported(Desktop.Action.BROWSE)) {
                        dtp.browse(uri);
                    }
                }
                catch (IOException | URISyntaxException e1) {
                    log.warn((Object)e1.getMessage());
                }
            }
        });
        mntmLink3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URI uri = new URI("https://circinteractome.nia.nih.gov");
                    Desktop dtp = Desktop.getDesktop();
                    if (Desktop.isDesktopSupported() && dtp.isSupported(Desktop.Action.BROWSE)) {
                        dtp.browse(uri);
                    }
                }
                catch (IOException | URISyntaxException e1) {
                    log.warn((Object)e1.getMessage());
                }
            }
        });
        mntmLink4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URI uri = new URI("http://circnet.mbc.nctu.edu.tw");
                    Desktop dtp = Desktop.getDesktop();
                    if (Desktop.isDesktopSupported() && dtp.isSupported(Desktop.Action.BROWSE)) {
                        dtp.browse(uri);
                    }
                }
                catch (IOException | URISyntaxException e1) {
                    log.warn((Object)e1.getMessage());
                }
            }
        });
        mntmLink5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URI uri = new URI("http://reprod.njmu.edu.cn/circrnadb");
                    Desktop dtp = Desktop.getDesktop();
                    if (Desktop.isDesktopSupported() && dtp.isSupported(Desktop.Action.BROWSE)) {
                        dtp.browse(uri);
                    }
                }
                catch (IOException | URISyntaxException e1) {
                    log.warn((Object)e1.getMessage());
                }
            }
        });
        mntmLink6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URI uri = new URI("http://starbase.sysu.edu.cn");
                    Desktop dtp = Desktop.getDesktop();
                    if (Desktop.isDesktopSupported() && dtp.isSupported(Desktop.Action.BROWSE)) {
                        dtp.browse(uri);
                    }
                }
                catch (IOException | URISyntaxException e1) {
                    log.warn((Object)e1.getMessage());
                }
            }
        });
        mntmLink7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URI uri = new URI("http://gb.whu.edu.cn/TSCD/");
                    Desktop dtp = Desktop.getDesktop();
                    if (Desktop.isDesktopSupported() && dtp.isSupported(Desktop.Action.BROWSE)) {
                        dtp.browse(uri);
                    }
                }
                catch (IOException | URISyntaxException e1) {
                    log.warn((Object)e1.getMessage());
                }
            }
        });
        mntmAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AboutDialog();
            }
        });
    }

    private void initToolBar() {
        JToolBar toolBar = new JToolBar();
        frame.getContentPane().add((Component)toolBar, "North");
        cbSpecies.setPreferredSize(new Dimension(180, 28));
        toolBar.add(cbSpecies);
        cbCircRnaTool.setPreferredSize(new Dimension(180, 28));
        toolBar.add(cbCircRnaTool);
        cbSample.setPreferredSize(new Dimension(180, 28));
        toolBar.add(cbSample);
        cbChrom.setPreferredSize(new Dimension(100, 28));
        toolBar.add(cbChrom);
        CircView.updateSpeciesCombo();
        CircView.updateCircRnaToolsCombo();
        CircView.updateSamplesCombo();
        CircView.updateCbChrom();
        CircView.updateGeneTransList();
        cbSpecies.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String species = (String)cbSpecies.getSelectedItem();
                    genes = MainData.getSpeciesData().get(species);
                    CircView.updateCircRnaToolsCombo();
                    CircView.updateSamplesCombo();
                    CircView.updateCbChrom();
                    CircView.updateGeneTransList();
                    CircView.updateRbpMreStatus();
                }
            }
        });
        cbCircRnaTool.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CircView.updateSamplesCombo();
                    CircView.updateGeneTransList();
                }
            }
        });
        cbSample.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CircView.updateGeneTransList();
                }
            }
        });
        cbChrom.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (CircView.this.cbChromInit) {
                        CircView.this.cbChromInit = false;
                        return;
                    }
                    CircView.updateGeneTransList();
                }
            }
        });
        cbChrom.addItem("Chrom");
        JLabel lbGeneName = new JLabel("Gene Name:", 4);
        final JTextField tfGeneName = new JTextField();
        tfGeneName.setPreferredSize(new Dimension(100, 20));
        JLabel lbLocation = new JLabel(" or Location:", 4);
        final JTextField tfLocStart = new JTextField();
        tfLocStart.setPreferredSize(new Dimension(100, 20));
        JLabel lbTo = new JLabel("-", 2);
        final JTextField tfLocEnd = new JTextField();
        tfLocEnd.setPreferredSize(new Dimension(100, 20));
        JButton btReset = new JButton("Reset");
        toolBar.addSeparator();
        toolBar.add(lbGeneName);
        toolBar.add(tfGeneName);
        toolBar.add(lbLocation);
        toolBar.add(tfLocStart);
        toolBar.add(lbTo);
        toolBar.add(tfLocEnd);
        toolBar.add(btReset);
        tfGeneName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.searchByGeneName();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.searchByGeneName();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void searchByGeneName() {
                String searchGeneName = tfGeneName.getText();
                geneTransName.removeAllElements();
                if (genes != null) {
                    for (String geneName : genes.keySet()) {
                        Gene gene = (Gene)genes.get(geneName);
                        for (String transName : gene.getGeneTranscripts().keySet()) {
                            GeneTranscript geneTrans = gene.getGeneTranscripts().get(transName);
                            if (!geneTrans.getGeneName().toLowerCase().contains(searchGeneName.toLowerCase()) && !searchGeneName.equalsIgnoreCase("") || geneTrans.getCircRnas().size() <= 0) continue;
                            geneTransName.addElement(String.valueOf(gene.getGeneName()) + " [" + geneTrans.getTranscriptName() + "] " + "(" + geneTrans.getCircRnas().size() + ")");
                        }
                    }
                    geneTransList.setListData(geneTransName);
                }
            }
        });
        tfLocStart.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.searchByLocation();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.searchByLocation();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void searchByLocation() {
                String str;
                long start = 0L;
                long end = Long.MAX_VALUE;
                if (tfLocStart.getText().matches("[0-9]+")) {
                    str = tfLocStart.getText();
                    start = Long.parseLong(str);
                }
                if (tfLocEnd.getText().matches("[0-9]+")) {
                    str = tfLocEnd.getText();
                    end = Long.parseLong(str);
                }
                geneTransName.removeAllElements();
                if (genes != null) {
                    for (String geneName : genes.keySet()) {
                        Gene gene = (Gene)genes.get(geneName);
                        for (String transName : gene.getGeneTranscripts().keySet()) {
                            GeneTranscript geneTrans = gene.getGeneTranscripts().get(transName);
                            if (start > geneTrans.getTxStart() || geneTrans.getTxEnd() > end || geneTrans.getCircRnas().size() <= 0) continue;
                            geneTransName.addElement(String.valueOf(gene.getGeneName()) + " [" + geneTrans.getTranscriptName() + "] " + "(" + geneTrans.getCircRnas().size() + ")");
                        }
                    }
                    geneTransList.setListData(geneTransName);
                }
            }
        });
        tfLocEnd.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.searchByLocation();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.searchByLocation();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void searchByLocation() {
                String str;
                long start = 0L;
                long end = Long.MAX_VALUE;
                if (tfLocStart.getText().matches("[0-9]+")) {
                    str = tfLocStart.getText();
                    start = Long.parseLong(str);
                }
                if (tfLocEnd.getText().matches("[0-9]+")) {
                    str = tfLocEnd.getText();
                    end = Long.parseLong(str);
                }
                geneTransName.removeAllElements();
                if (genes != null) {
                    for (String geneName : genes.keySet()) {
                        Gene gene = (Gene)genes.get(geneName);
                        for (String transName : gene.getGeneTranscripts().keySet()) {
                            GeneTranscript geneTrans = gene.getGeneTranscripts().get(transName);
                            if (start > geneTrans.getTxStart() || geneTrans.getTxEnd() > end || geneTrans.getCircRnas().size() <= 0) continue;
                            geneTransName.addElement(String.valueOf(gene.getGeneName()) + " [" + geneTrans.getTranscriptName() + "] " + "(" + geneTrans.getCircRnas().size() + ")");
                        }
                    }
                    geneTransList.setListData(geneTransName);
                }
            }
        });
        btReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CircView.updateGeneTransList();
                tfGeneName.setText("");
                tfLocStart.setText("");
                tfLocEnd.setText("");
            }
        });
    }

    private void initMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        frame.getContentPane().add((Component)mainPanel, "Center");
        JPanel geneTransPanel = new JPanel(new BorderLayout());
        final JComboBox<String> cbSort = new JComboBox<String>();
        cbSort.setPreferredSize(new Dimension(mainPanel.getWidth(), 28));
        cbSort.addItem("sort name by asc");
        cbSort.addItem("sort name by desc");
        cbSort.addItem("sort position by asc");
        cbSort.addItem("sort position by desc");
        cbSort.addItem("sort abundance by asc");
        cbSort.addItem("sort abundance by desc");
        geneTransPanel.add(cbSort, "North");
        JScrollPane geneTransScrollPane = new JScrollPane(geneTransList);
        geneTransScrollPane.setPreferredSize(new Dimension(250, mainPanel.getHeight()));
        geneTransPanel.add((Component)geneTransScrollPane, "Center");
        mainPanel.add((Component)geneTransPanel, "West");
        this.imagePanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.imagePanel, "Center");
        JPanel imageToolBar = new JPanel();
        imageToolBar.setLayout(new FlowLayout());
        imageToolBar.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.imagePanel.add((Component)imageToolBar, "North");
        JButton btHome = new JButton("Home");
        cbCircRnaSelect = new JComboBox();
        JButton btZoomIn = new JButton("Zoom In");
        JButton btZoomOut = new JButton("Zoom Out");
        cbRbp = new JCheckBox("RBP", null, false);
        cbMre = new JCheckBox("MRE", null, false);
        JButton btDetails = new JButton("Details");
        JButton btSaveImage = new JButton("Save Image");
        cbCircRnaSelect.setPreferredSize(new Dimension(200, 28));
        imageToolBar.add(btHome);
        imageToolBar.add(cbCircRnaSelect);
        imageToolBar.add(btZoomIn);
        imageToolBar.add(btZoomOut);
        imageToolBar.add(cbRbp);
        imageToolBar.add(cbMre);
        imageToolBar.add(btDetails);
        imageToolBar.add(btSaveImage);
        if (conn == null || cbSpecies.getSelectedItem() == null || this.circRnaImage.getGt() == null) {
            cbRbp.setEnabled(false);
            cbMre.setEnabled(false);
        }
        this.circRnaImage = new CircRnaImagePanel();
        final JScrollPane imageScrollPane = new JScrollPane(this.circRnaImage);
        this.imagePanel.add((Component)imageScrollPane, "Center");
        tipsTA = new JTextArea();
        tipsTA.setLineWrap(true);
        tipsTA.setWrapStyleWord(true);
        this.circRnaImage.add(tipsTA);
        this.circRnaImage.setLayout(null);
        cbSort.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String sortType = cbSort.getSelectedItem().toString();
                    CircView.updateGeneTransList(sortType);
                }
            }
        });
        geneTransList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                cbRbp.setSelected(false);
                cbMre.setSelected(false);
                if (e.getValueIsAdjusting()) {
                    CircView.this.circRnaImage.clearRbp();
                    CircView.this.circRnaImage.clearMre();
                    CircView.this.preDisplay();
                    CircView.this.display();
                    CircView.this.updateCircRnasCheckList();
                    CircView.updateRbpMreStatus();
                }
            }
        });
        geneTransList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent key) {
                cbRbp.setSelected(false);
                cbMre.setSelected(false);
                CircView.this.circRnaImage.clearRbp();
                CircView.this.circRnaImage.clearMre();
                CircView.this.preDisplay();
                CircView.this.display();
                CircView.this.updateCircRnasCheckList();
                CircView.updateRbpMreStatus();
            }
        });
        btHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (cbCircRnaSelect.getItemCount() > 0 && !cbCircRnaSelect.getSelectedItem().toString().equalsIgnoreCase("All")) {
                    cbCircRnaSelect.setSelectedIndex(0);
                }
            }
        });
        cbCircRnaSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String circRnaId = "";
                circRnaId = cbCircRnaSelect.getSelectedItem() != null ? cbCircRnaSelect.getSelectedItem().toString() : "All";
                if (circRnaId.equalsIgnoreCase("All")) {
                    CircView.this.circRnaImage.selectAllCircRnas();
                } else {
                    CircView.this.circRnaImage.selectOneCircRna(circRnaId);
                }
                CircView.this.display();
            }
        });
        btZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CircView.this.circRnaImage.zoomIn();
            }
        });
        btZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CircView.this.circRnaImage.zoomOut();
            }
        });
        cbRbp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = cbRbp.isSelected();
                if (selected) {
                    if (conn != null) {
                        if (cbSpecies.getSelectedItem() != null && CircView.this.circRnaImage.getGt() != null) {
                            DataLoadingDialog dataLoadingDialog = new DataLoadingDialog((Frame)frame, "Loading RBP Data ...");
                            CircView.this.circRnaImage.queryRbpData(cbSpecies.getSelectedItem().toString(), CircView.this.circRnaImage.getGt());
                            dataLoadingDialog.setVisible(false);
                        }
                    } else {
                        JOptionPane.showMessageDialog(frame, "Can NOT connect to the Server!");
                        cbRbp.setSelected(false);
                    }
                    CircView.this.display();
                } else {
                    CircView.this.circRnaImage.clearRbp();
                    CircView.this.display();
                }
            }
        });
        cbMre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = cbMre.isSelected();
                if (selected) {
                    if (conn != null) {
                        if (cbSpecies.getSelectedItem() != null && CircView.this.circRnaImage.getGt() != null) {
                            DataLoadingDialog dataLoadingDialog = new DataLoadingDialog((Frame)frame, "Loading MRE Data ...");
                            CircView.this.circRnaImage.queryMreData(cbSpecies.getSelectedItem().toString(), CircView.this.circRnaImage.getGt());
                            dataLoadingDialog.setVisible(false);
                        }
                    } else {
                        JOptionPane.showMessageDialog(frame, "Can NOT connect to the Server!");
                        cbMre.setSelected(false);
                    }
                    CircView.this.display();
                } else {
                    CircView.this.circRnaImage.clearMre();
                    CircView.this.display();
                }
            }
        });
        btDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DetailsResultDialog(CircView.this.circRnaImage.getDetails(CircView.this.circRnaImage.getGt()));
            }
        });
        btSaveImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SaveImageDialog(CircView.this.circRnaImage);
            }
        });
        this.circRnaImage.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (cbCircRnaSelect.getItemCount() == 0) {
                    return;
                }
                if (!cbCircRnaSelect.getSelectedItem().equals("All")) {
                    cbCircRnaSelect.setSelectedItem("All");
                    CircView.this.circRnaImage.selectAllCircRnas();
                    tipsTA.setVisible(false);
                    CircView.this.display();
                } else {
                    int circRnaIndex = -1;
                    int i = 0;
                    while (i < CircView.this.circRnaImage.getCircX().size()) {
                        if (CircView.this.hitCirc(CircView.this.circRnaImage.getCircX().get(i), CircView.this.circRnaImage.getCircY().get(i), CircView.this.circRnaImage.getCircR(), e.getX(), e.getY())) {
                            circRnaIndex = i;
                            break;
                        }
                        ++i;
                    }
                    if (circRnaIndex >= 0) {
                        cbCircRnaSelect.setSelectedIndex(++circRnaIndex);
                        CircView.this.circRnaImage.selectOneCircRna((String)cbCircRnaSelect.getItemAt(circRnaIndex));
                        tipsTA.setVisible(false);
                        CircView.this.display();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.circRnaImage.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int tipsTop = 0;
                int tipsLeft = 0;
                if (cbCircRnaSelect.getItemCount() == 0) {
                    return;
                }
                int circRnaIndex = -1;
                int i = 0;
                while (i < CircView.this.circRnaImage.getCircX().size()) {
                    if (CircView.this.hitCirc(CircView.this.circRnaImage.getCircX().get(i), CircView.this.circRnaImage.getCircY().get(i), CircView.this.circRnaImage.getCircR(), e.getX(), e.getY())) {
                        tipsLeft = (int)Math.round(CircView.this.circRnaImage.getCircX().get(i) - CircView.this.circRnaImage.getCircR());
                        tipsTop = (int)Math.round(CircView.this.circRnaImage.getCircY().get(i) + CircView.this.circRnaImage.getCircR() * 2.0);
                        circRnaIndex = i;
                        break;
                    }
                    ++i;
                }
                if (circRnaIndex >= 0) {
                    String info = "";
                    info = cbCircRnaSelect.getSelectedItem().equals("All") ? CircView.this.circRnaImage.getCircRnaInfo((String)cbCircRnaSelect.getItemAt(circRnaIndex + 1)) : CircView.this.circRnaImage.getCircRnaInfo(cbCircRnaSelect.getSelectedItem().toString());
                    int fontSize = (int)Math.round((double)CircView.this.circRnaImage.getHeight() / 80.0) < (int)Math.round((double)imageScrollPane.getHeight() / 60.0) ? (int)Math.round((double)CircView.this.circRnaImage.getHeight() / 80.0) : (int)Math.round((double)imageScrollPane.getHeight() / 60.0);
                    tipsTA.setFont(new Font("TimeRomes", 0, fontSize));
                    int tipsLength = imageScrollPane.getWidth() / 2;
                    int tipsHeight = imageScrollPane.getHeight() / 4;
                    if (tipsLeft + tipsLength > CircView.this.circRnaImage.getWidth()) {
                        tipsLeft = CircView.this.circRnaImage.getWidth() - tipsLength;
                    }
                    tipsTA.setBounds(tipsLeft, tipsTop, tipsLength, tipsHeight);
                    tipsTA.setRows(12);
                    tipsTA.setColumns(150);
                    tipsTA.setText(info);
                    tipsTA.setVisible(true);
                } else {
                    tipsTA.setVisible(false);
                }
            }
        });
    }

    private boolean hitCirc(double circX, double circY, double circR, int x, int y) {
        boolean ret = false;
        if (circX - circR <= (double)x && (double)x <= circX + circR && circY - circR <= (double)y && (double)y <= circY + circR) {
            ret = true;
        }
        return ret;
    }

    private void preDisplay() {
        String geneTransName = geneTransList.getSelectedValue();
        String[] tmp = geneTransName.split(" ");
        String gName = tmp[0];
        String trName = tmp[1].substring(1, tmp[1].length() - 1);
        GeneTranscript geneTranscript = null;
        block0: for (String geneName : genes.keySet()) {
            if (!geneName.equalsIgnoreCase(gName)) continue;
            Gene gene = genes.get(geneName);
            for (String string : gene.getGeneTranscripts().keySet()) {
                if (!string.equalsIgnoreCase(trName)) continue;
                geneTranscript = gene.getGeneTranscripts().get(string);
                break block0;
            }
        }
        String species = (String)cbSpecies.getSelectedItem();
        TreeMap<String, String> sampleName = new TreeMap<String, String>();
        TreeMap<String, String> toolName = new TreeMap<String, String>();
        for (Vector vector : MainData.getCircRnaFilesInfo()) {
            String sname = (String)vector.get(0);
            String tname = (String)vector.get(1);
            String fname = (String)vector.get(2);
            if (!species.equalsIgnoreCase(sname)) continue;
            toolName.put(tname, tname);
            int tmpP = fname.lastIndexOf(".");
            sampleName.put(fname.substring(0, tmpP), fname);
        }
        this.circRnaImage.setGt(geneTranscript, sampleName.size(), toolName.size());
    }

    private void updateCircRnasCheckList() {
        cbCircRnaSelect.removeAllItems();
        cbCircRnaSelect.addItem("All");
        for (String circRnaId : this.circRnaImage.getGtBackup().getCircRnas().keySet()) {
            cbCircRnaSelect.addItem(circRnaId);
        }
    }

    public static void updateRbpMreStatus() {
        block7: {
            if (cbSpecies.getSelectedItem() != null) {
                String species = cbSpecies.getSelectedItem().toString();
                String rbpTableName = "rbp_" + DbUtil.species2TableName(species);
                String mreTableName = "mre_" + DbUtil.species2TableName(species);
                try {
                    if (DbUtil.existTable(conn, rbpTableName)) {
                        cbRbp.setEnabled(true);
                    } else {
                        cbRbp.setEnabled(false);
                    }
                    if (DbUtil.existTable(conn, mreTableName)) {
                        cbMre.setEnabled(true);
                        break block7;
                    }
                    cbMre.setEnabled(false);
                }
                catch (ClassNotFoundException | SQLException e) {
                    log.warn((Object)e.getMessage());
                }
            } else {
                cbRbp.setEnabled(false);
                cbMre.setEnabled(false);
            }
        }
    }

    private void display() {
        this.circRnaImage.createOneImage(this.imagePanel.getWidth(), this.imagePanel.getHeight(), conn);
        this.circRnaImage.repaint();
    }

    public static void updateGeneTransList() {
        geneTransName.removeAllElements();
        if (genes != null) {
            String toolName = (String)cbCircRnaTool.getSelectedItem();
            String sampleName = (String)cbSample.getSelectedItem();
            String chrom = (String)cbChrom.getSelectedItem();
            for (String geneName : genes.keySet()) {
                Gene gene = genes.get(geneName);
                for (String transName : gene.getGeneTranscripts().keySet()) {
                    CircRna circRna;
                    boolean sign;
                    GeneTranscript geneTrans = gene.getGeneTranscripts().get(transName);
                    if (geneTrans.getCircRnas().size() <= 0 || !chrom.equalsIgnoreCase("Chrom") && !geneTrans.getChrom().equalsIgnoreCase(chrom)) continue;
                    if (toolName.equalsIgnoreCase("Tool") && sampleName.equalsIgnoreCase("Sample")) {
                        geneTransName.addElement(String.valueOf(gene.getGeneName()) + " [" + geneTrans.getTranscriptName() + "] " + "(" + geneTrans.getCircRnas().size() + ")");
                        continue;
                    }
                    if (toolName.equalsIgnoreCase("Tool")) {
                        sign = false;
                        for (String circRnaName : geneTrans.getCircRnas().keySet()) {
                            circRna = geneTrans.getCircRnas().get(circRnaName);
                            for (String sname : circRna.getFiles().keySet()) {
                                if (!sampleName.equalsIgnoreCase(sname)) continue;
                                sign = true;
                                break;
                            }
                            if (sign) break;
                        }
                        if (!sign) continue;
                        geneTransName.addElement(String.valueOf(gene.getGeneName()) + " [" + geneTrans.getTranscriptName() + "] " + "(" + geneTrans.getCircRnas().size() + ")");
                        continue;
                    }
                    if (sampleName.equalsIgnoreCase("Sample")) {
                        sign = false;
                        for (String circRnaName : geneTrans.getCircRnas().keySet()) {
                            circRna = geneTrans.getCircRnas().get(circRnaName);
                            for (String tname : circRna.getCircTools().keySet()) {
                                if (!toolName.equalsIgnoreCase(tname)) continue;
                                sign = true;
                                break;
                            }
                            if (sign) break;
                        }
                        if (!sign) continue;
                        geneTransName.addElement(String.valueOf(gene.getGeneName()) + " [" + geneTrans.getTranscriptName() + "] " + "(" + geneTrans.getCircRnas().size() + ")");
                        continue;
                    }
                    sign = false;
                    for (String circRnaName : geneTrans.getCircRnas().keySet()) {
                        circRna = geneTrans.getCircRnas().get(circRnaName);
                        for (String sname : circRna.getFiles().keySet()) {
                            if (!sampleName.equalsIgnoreCase(sname)) continue;
                            sign = true;
                            break;
                        }
                        if (sign) break;
                    }
                    if (!sign) continue;
                    sign = false;
                    for (String circRnaName : geneTrans.getCircRnas().keySet()) {
                        circRna = geneTrans.getCircRnas().get(circRnaName);
                        for (String tname : circRna.getCircTools().keySet()) {
                            if (!toolName.equalsIgnoreCase(tname)) continue;
                            sign = true;
                            break;
                        }
                        if (sign) break;
                    }
                    if (!sign) continue;
                    geneTransName.addElement(String.valueOf(gene.getGeneName()) + " [" + geneTrans.getTranscriptName() + "] " + "(" + geneTrans.getCircRnas().size() + ")");
                }
            }
        }
        geneTransList.setListData(geneTransName);
    }

    public static void updateGeneTransList(String sort) {
        TreeMap<Object, Long> geneTrans_position;
        TreeMap<Object, Integer> geneTrans_juncReads;
        Comparator<String> keyComparator = null;
        Comparator<Map.Entry<String, Long>> positionValueComparator = null;
        Comparator<Map.Entry<String, Integer>> abundanceValueComparator = null;
        if (sort.contains("name")) {
            if (sort.contains("asc")) {
                keyComparator = new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                };
            } else if (sort.contains("desc")) {
                keyComparator = new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o2.compareToIgnoreCase(o1);
                    }
                };
            }
        } else if (sort.contains("position")) {
            if (sort.contains("asc")) {
                positionValueComparator = new Comparator<Map.Entry<String, Long>>(){

                    @Override
                    public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                        return (int)(o1.getValue() - o2.getValue());
                    }
                };
            } else if (sort.contains("desc")) {
                positionValueComparator = new Comparator<Map.Entry<String, Long>>(){

                    @Override
                    public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                        return (int)(o2.getValue() - o1.getValue());
                    }
                };
            }
        } else if (sort.contains("abundance")) {
            if (sort.contains("asc")) {
                abundanceValueComparator = new Comparator<Map.Entry<String, Integer>>(){

                    @Override
                    public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                        return o1.getValue() - o2.getValue();
                    }
                };
            } else if (sort.contains("desc")) {
                abundanceValueComparator = new Comparator<Map.Entry<String, Integer>>(){

                    @Override
                    public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                        return o2.getValue() - o1.getValue();
                    }
                };
            }
        }
        if (sort.contains("name")) {
            geneTrans_juncReads = new TreeMap(keyComparator);
            geneTrans_position = new TreeMap(keyComparator);
        } else {
            geneTrans_juncReads = new TreeMap();
            geneTrans_position = new TreeMap();
        }
        for (String string : geneTransName) {
            String[] tmp = string.split(" \\[");
            String geneName = tmp[0];
            String[] tmp2 = tmp[1].split("\\]");
            String transName = tmp2[0];
            Gene gene = genes.get(geneName);
            if (gene != null) {
                GeneTranscript geneTrans = gene.getGeneTranscripts().get(transName);
                geneTrans_juncReads.put(string, geneTrans.getTotalJunctionReads());
                geneTrans_position.put(string, geneTrans.getCdsStart());
                continue;
            }
            System.out.println("Gene Transcript Name error " + string);
        }
        geneTransName.removeAllElements();
        if (sort.contains("name")) {
            for (Map.Entry entry : geneTrans_juncReads.entrySet()) {
                geneTransName.addElement((String)entry.getKey());
            }
        } else if (sort.contains("position")) {
            ArrayList arrayList = new ArrayList(geneTrans_position.entrySet());
            Collections.sort(arrayList, positionValueComparator);
            for (Map.Entry entry : arrayList) {
                geneTransName.addElement((String)entry.getKey());
            }
        } else if (sort.contains("abundance")) {
            ArrayList arrayList = new ArrayList(geneTrans_juncReads.entrySet());
            Collections.sort(arrayList, abundanceValueComparator);
            for (Map.Entry entry : arrayList) {
                geneTransName.addElement((String)entry.getKey());
            }
        }
        geneTransList.setListData(geneTransName);
    }

    public static void updateCbChrom() {
        cbChrom.removeAllItems();
        cbChrom.addItem("Chrom");
        if (genes != null) {
            TreeMap<String, String> chrom = new TreeMap<String, String>();
            for (String geneName : genes.keySet()) {
                Gene gene = genes.get(geneName);
                for (String transcriptName : gene.getGeneTranscripts().keySet()) {
                    GeneTranscript transcript = gene.getGeneTranscripts().get(transcriptName);
                    if (transcript.getCircRnas().size() <= 0) continue;
                    chrom.put(transcript.getChrom(), transcript.getChrom());
                }
            }
            for (String chr : chrom.keySet()) {
                cbChrom.addItem(chr);
            }
        }
    }

    public static void setSpeciesCombo(String species) {
        cbSpecies.setSelectedItem(species);
    }

    public static void setCircRnaToolsCombo(String circRnaTool) {
        cbCircRnaTool.setSelectedItem(circRnaTool);
    }

    public static void updateSpeciesCombo() {
        cbSpecies.removeAllItems();
        for (String speciesName : MainData.getSpeciesData().keySet()) {
            cbSpecies.addItem(speciesName);
        }
        String sname = (String)cbSpecies.getSelectedItem();
        genes = sname == null ? null : MainData.getSpeciesData().get(sname);
    }

    public static void updateCircRnaToolsCombo() {
        cbCircRnaTool.removeAllItems();
        cbCircRnaTool.addItem("Tool");
        if (cbSpecies.getSelectedItem() == null) {
            return;
        }
        String speciesName = cbSpecies.getSelectedItem().toString();
        TreeMap<String, String> tools = new TreeMap<String, String>();
        for (Vector<String> rowData : MainData.getCircRnaFilesInfo()) {
            String sname = rowData.get(0);
            String tname = rowData.get(1);
            if (!speciesName.equalsIgnoreCase(sname)) continue;
            tools.put(tname, tname);
        }
        for (String toolName : tools.keySet()) {
            cbCircRnaTool.addItem(toolName);
        }
    }

    public static void updateSamplesCombo() {
        cbSample.removeAllItems();
        cbSample.addItem("Sample");
        if (cbSpecies.getSelectedItem() == null) {
            return;
        }
        if (cbCircRnaTool.getSelectedItem() == null) {
            return;
        }
        String speciesName = cbSpecies.getSelectedItem().toString();
        String circRnaTool = cbCircRnaTool.getSelectedItem().toString();
        TreeMap<String, String> samples = new TreeMap<String, String>();
        for (Vector<String> rowData : MainData.getCircRnaFilesInfo()) {
            String sname = rowData.get(0);
            String tname = rowData.get(1);
            String fname = rowData.get(2);
            if (!speciesName.equalsIgnoreCase(sname) || !circRnaTool.equalsIgnoreCase(tname) && !circRnaTool.equalsIgnoreCase("Tool")) continue;
            samples.put(fname, fname);
        }
        for (String sampleName : samples.keySet()) {
            cbSample.addItem(sampleName);
        }
    }

    public TreeMap<String, Gene> getMainData() {
        return genes;
    }

    public static JComboBox<String> getCbCircRnaSelect() {
        return cbCircRnaSelect;
    }

    public static void setCbCircRnaSelect(JComboBox<String> cbCircRnaSelect) {
        CircView.cbCircRnaSelect = cbCircRnaSelect;
    }
}

