/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.whu;

import cn.edu.whu.CircRna;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.TreeMap;
import java.util.Vector;

public class GeneTranscript
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String geneName;
    private String transcriptName;
    private String chrom;
    private String strand;
    private Long txStart;
    private Long txEnd;
    private Long cdsStart;
    private Long cdsEnd;
    private Integer exonCount;
    private Vector<Long> exonStarts;
    private Vector<Long> exonEnds;
    private TreeMap<String, CircRna> circRnas;
    private TreeMap<String, Integer> circRnasNum;
    private int totalJunctionReads;

    public GeneTranscript(String geneName) {
        this.setGeneName(geneName);
        this.exonStarts = new Vector();
        this.exonEnds = new Vector();
        this.setCircRnas(new TreeMap<String, CircRna>());
        this.setCircRnasNum(new TreeMap<String, Integer>());
        this.setTotalJunctionReads(0);
    }

    public String getGeneName() {
        return this.geneName;
    }

    public void setGeneName(String geneName) {
        this.geneName = geneName;
    }

    public String getTranscriptName() {
        return this.transcriptName;
    }

    public void setTranscriptName(String transcriptName) {
        this.transcriptName = transcriptName;
    }

    public String getChrom() {
        return this.chrom;
    }

    public void setChrom(String chrom) {
        this.chrom = chrom;
    }

    public String getStrand() {
        return this.strand;
    }

    public void setStrand(String strand) {
        this.strand = strand;
    }

    public Long getTxStart() {
        return this.txStart;
    }

    public void setTxStart(Long txStart) {
        this.txStart = txStart;
    }

    public Long getTxEnd() {
        return this.txEnd;
    }

    public void setTxEnd(Long txEnd) {
        this.txEnd = txEnd;
    }

    public Long getCdsStart() {
        return this.cdsStart;
    }

    public void setCdsStart(Long cdsStart) {
        this.cdsStart = cdsStart;
    }

    public Long getCdsEnd() {
        return this.cdsEnd;
    }

    public void setCdsEnd(Long cdsEnd) {
        this.cdsEnd = cdsEnd;
    }

    public Integer getExonCount() {
        return this.exonCount;
    }

    public void setExonCount(Integer exonCount) {
        this.exonCount = exonCount;
    }

    public Vector<Long> getExonStarts() {
        return this.exonStarts;
    }

    public void setExonStarts(Vector<Long> exonStarts) {
        this.exonStarts = exonStarts;
    }

    public Vector<Long> getExonEnds() {
        return this.exonEnds;
    }

    public void setExonEnds(Vector<Long> exonEnds) {
        this.exonEnds = exonEnds;
    }

    public TreeMap<String, Integer> getCircRnasNum() {
        return this.circRnasNum;
    }

    public void setCircRnasNum(TreeMap<String, Integer> circRnasNum) {
        this.circRnasNum = circRnasNum;
    }

    public int getTotalJunctionReads() {
        return this.totalJunctionReads;
    }

    public void setTotalJunctionReads(int totalJunctionReads) {
        this.totalJunctionReads = totalJunctionReads;
    }

    public TreeMap<String, CircRna> getCircRnas() {
        return this.circRnas;
    }

    public void setCircRnas(TreeMap<String, CircRna> circRnas) {
        this.circRnas = circRnas;
    }

    public GeneTranscript deepClone() {
        ByteArrayOutputStream byteOut = null;
        ObjectOutputStream objOut = null;
        ByteArrayInputStream byteIn = null;
        ObjectInputStream objIn = null;
        try {
            byteOut = new ByteArrayOutputStream();
            objOut = new ObjectOutputStream(byteOut);
            objOut.writeObject(this);
            byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            objIn = new ObjectInputStream(byteIn);
            GeneTranscript geneTranscript = (GeneTranscript)objIn.readObject();
            return geneTranscript;
        }
        catch (IOException e) {
            throw new RuntimeException("Clone Object failed in IO.", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found.", e);
        }
        finally {
            try {
                byteIn = null;
                byteOut = null;
                if (objOut != null) {
                    objOut.close();
                }
                if (objIn != null) {
                    objIn.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

