/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.whu;

import cn.edu.whu.CircView;
import cn.edu.whu.Gene;
import cn.edu.whu.util.Constant;
import cn.edu.whu.util.DbConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;

public class MainData {
    private static TreeMap<String, String> speciesFile;
    private static TreeMap<String, TreeMap<String, Gene>> speciesData;
    private static Vector<String> speciesNames;
    private static Vector<String> circRnaToolNames;
    private static Vector<Vector<String>> circRnaFilesInfo;
    private static Properties properties;
    private static DbConfig dbConfig;

    public MainData() {
        speciesFile = new TreeMap();
        speciesData = new TreeMap();
        speciesNames = new Vector();
        circRnaToolNames = new Vector();
        circRnaFilesInfo = new Vector();
        properties = new Properties();
        dbConfig = new DbConfig();
        this.configure();
    }

    private void configure() {
        File file = new File("config.properties");
        if (file.exists()) {
            MainData.readDbConfig();
        } else {
            this.initDbConfig();
            MainData.writeDbConfig();
        }
        this.initSpeciesFile();
        this.initTools();
    }

    private void initSpeciesFile() {
        for (String speciesName : Constant.SPECIES) {
            File file = new File(Constant.SPECIES_FILE.get(speciesName));
            if (file.exists()) {
                speciesNames.add(speciesName);
                speciesFile.put(speciesName, Constant.SPECIES_FILE.get(speciesName));
                continue;
            }
            CircView.log.info((Object)("Can not find annotation file " + file.getName()));
        }
    }

    private void initTools() {
        for (String circRnaToolName : Constant.CIRCRNA_TOOLS) {
            circRnaToolNames.add(circRnaToolName);
        }
    }

    private void initDbConfig() {
        CircView.log.info((Object)"Init Default Config");
        dbConfig.setDbServer("127.0.0.1");
        dbConfig.setDbPort("3306");
        dbConfig.setDbUser("root");
        dbConfig.setDbPasswd("12345");
        dbConfig.setDbName("mre_rbp");
    }

    public static void readDbConfig() {
        CircView.log.info((Object)"config.properties is loaded");
        try {
            FileInputStream in = new FileInputStream("config.properties");
            properties.load(in);
            dbConfig.setDbServer(properties.getProperty("dbserver"));
            dbConfig.setDbPort(properties.getProperty("dbport"));
            dbConfig.setDbUser(properties.getProperty("dbuser"));
            dbConfig.setDbPasswd(properties.getProperty("dbpasswd"));
            dbConfig.setDbName(properties.getProperty("dbname"));
        }
        catch (IOException e) {
            CircView.log.info((Object)e.getMessage());
        }
    }

    public static void writeDbConfig() {
        try {
            properties.setProperty("dbserver", "127.0.0.1");
            properties.setProperty("dbport", "3306");
            properties.setProperty("dbuser", "root");
            properties.setProperty("dbpasswd", "12345");
            properties.setProperty("dbname", "mre_rbp");
            FileOutputStream os = new FileOutputStream("config.properties");
            properties.store(os, "Save Config File");
        }
        catch (IOException e) {
            CircView.log.error((Object)e.getMessage());
        }
    }

    public static TreeMap<String, TreeMap<String, Gene>> getSpeciesData() {
        return speciesData;
    }

    public static void setSpeciesData(TreeMap<String, TreeMap<String, Gene>> speciesData) {
        MainData.speciesData = speciesData;
    }

    public static TreeMap<String, String> getSpeciesFile() {
        return speciesFile;
    }

    public static void setSpeciesFile(TreeMap<String, String> speciesFile) {
        MainData.speciesFile = speciesFile;
    }

    public static Vector<String> getSpeciesNames() {
        return speciesNames;
    }

    public static void setSpeciesNames(Vector<String> speciesNames) {
        MainData.speciesNames = speciesNames;
    }

    public static Vector<String> getCircRnaToolNames() {
        return circRnaToolNames;
    }

    public static void setCircRnaToolNames(Vector<String> circRnaToolNames) {
        MainData.circRnaToolNames = circRnaToolNames;
    }

    public static Vector<Vector<String>> getCircRnaFilesInfo() {
        return circRnaFilesInfo;
    }

    public static void setCircRnaFilesInfo(Vector<Vector<String>> circRnaFilesInfo) {
        MainData.circRnaFilesInfo = circRnaFilesInfo;
    }

    public static Properties getProperties() {
        return properties;
    }

    public static void setProperties(Properties properties) {
        MainData.properties = properties;
    }

    public static DbConfig getDbConfig() {
        return dbConfig;
    }

    public static void setDbConfig(DbConfig dbConfig) {
        MainData.dbConfig = dbConfig;
    }
}

