/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.whu.ui;

import cn.edu.whu.CircView;
import cn.edu.whu.MainData;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;

public class CircRnaDataClearDialog
extends JDialog {
    private static final long serialVersionUID = 1L;

    public CircRnaDataClearDialog() {
        super(CircView.frame);
        this.initUi();
        this.setTitle("Clear CircRNA Data for:");
        this.setResizable(false);
        this.setSize(300, 65);
        this.setLayout(new FlowLayout());
        this.centerScreen();
    }

    private void centerScreen() {
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
        super.setVisible(true);
        this.requestFocus();
    }

    private void initUi() {
        final JComboBox<String> cbSpecies = new JComboBox<String>();
        JButton btClear = new JButton("Clear");
        cbSpecies.setPreferredSize(new Dimension(160, 28));
        for (String speciesName : MainData.getSpeciesData().keySet()) {
            cbSpecies.addItem(speciesName);
        }
        this.getContentPane().add(cbSpecies);
        this.getContentPane().add(btClear);
        btClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (cbSpecies.getSelectedItem() == null) {
                    return;
                }
                String delSpecies = cbSpecies.getSelectedItem().toString();
                if (MainData.getSpeciesData().get(delSpecies) != null) {
                    MainData.getSpeciesData().remove(delSpecies);
                }
                CircView.log.error((Object)("CircRNA Data for " + delSpecies + " is CLEARED"));
                int i = MainData.getCircRnaFilesInfo().size() - 1;
                while (i >= 0) {
                    Vector<String> rowData = MainData.getCircRnaFilesInfo().get(i);
                    String sname = rowData.get(0);
                    if (delSpecies.equalsIgnoreCase(sname)) {
                        MainData.getCircRnaFilesInfo().remove(i);
                    }
                    --i;
                }
                CircView.log.error((Object)("CircRNA files for " + delSpecies + " is DELETED"));
                CircView.updateSpeciesCombo();
                CircView.updateCircRnaToolsCombo();
                CircView.updateSamplesCombo();
                CircView.updateCbChrom();
                CircView.updateGeneTransList();
                CircRnaDataClearDialog.this.dispose();
            }
        });
    }
}

