/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.whu.ui;

import cn.edu.whu.CircRnaTool;
import cn.edu.whu.CircView;
import cn.edu.whu.Gene;
import cn.edu.whu.MainData;
import cn.edu.whu.exception.FileReadException;
import cn.edu.whu.ui.DataLoadingDialog;
import cn.edu.whu.ui.OpenFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class CircRnaDataLoadDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private Vector<Vector<String>> tableData;
    private JComboBox<String> cbSpecies;
    private JComboBox<String> cbCircRnaTool;

    public CircRnaDataLoadDialog() {
        super(CircView.frame);
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.initUi();
        this.setTitle("Load CircRNA files");
        this.setResizable(false);
        this.setSize(600, 400);
        this.centerScreen();
    }

    private void centerScreen() {
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
        super.setVisible(true);
        this.requestFocus();
    }

    private void initUi() {
        JPanel jpNorth = new JPanel(new FlowLayout());
        this.cbSpecies = new JComboBox();
        this.cbCircRnaTool = new JComboBox();
        JButton btAdd = new JButton("Add Files");
        this.cbSpecies.setPreferredSize(new Dimension(200, 28));
        this.cbCircRnaTool.setPreferredSize(new Dimension(200, 28));
        jpNorth.add(this.cbSpecies);
        jpNorth.add(this.cbCircRnaTool);
        jpNorth.add(btAdd);
        this.getContentPane().add((Component)jpNorth, "North");
        for (String speciesName : MainData.getSpeciesNames()) {
            this.cbSpecies.addItem(speciesName);
        }
        for (String circRnaToolName : MainData.getCircRnaToolNames()) {
            this.cbCircRnaTool.addItem(circRnaToolName);
        }
        final Vector<String> colName = new Vector<String>();
        colName.addElement("Species");
        colName.addElement("CircRNA Tool");
        colName.addElement("File Name");
        colName.addElement("File Path");
        this.tableData = new Vector();
        final DefaultTableModel model = new DefaultTableModel();
        this.table = new JTable(model);
        model.setDataVector(this.tableData, colName);
        JScrollPane jsPane = new JScrollPane(this.table);
        this.getContentPane().add((Component)jsPane, "Center");
        JPanel jpSouth = new JPanel(new FlowLayout());
        JButton btOpen = new JButton("Open");
        JButton btClear = new JButton("Clear");
        jpSouth.add(btOpen);
        jpSouth.add(btClear);
        this.getContentPane().add((Component)jpSouth, "South");
        btAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CircRnaDataLoadDialog.this.cbSpecies.getSelectedItem() == null) {
                    JOptionPane.showMessageDialog(CircView.frame, "Species Name is needed");
                    return;
                }
                if (CircRnaDataLoadDialog.this.cbCircRnaTool.getSelectedItem() == null) {
                    JOptionPane.showMessageDialog(CircView.frame, "Tool Name is needed");
                    return;
                }
                String speciesName = CircRnaDataLoadDialog.this.cbSpecies.getSelectedItem().toString();
                String circRnaToolName = CircRnaDataLoadDialog.this.cbCircRnaTool.getSelectedItem().toString();
                String pattern = "\\s+";
                if (speciesName.matches(pattern)) {
                    JOptionPane.showMessageDialog(CircView.frame, "Species Name is needed");
                    return;
                }
                if (circRnaToolName.matches(pattern)) {
                    JOptionPane.showMessageDialog(CircView.frame, "Tool Name is needed");
                    return;
                }
                OpenFileChooser openFile = new OpenFileChooser("Open CircRNA Files");
                openFile.setMultiSelectionEnabled(true);
                openFile.setFileSelectionMode(0);
                openFile.setFileHidingEnabled(true);
                int returnValue = openFile.showOpenDialog(null);
                if (returnValue == 0) {
                    File[] files = null;
                    File[] fileArray = files = openFile.getSelectedFiles();
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        Vector<String> rowData = new Vector<String>();
                        rowData.addElement(speciesName);
                        rowData.addElement(circRnaToolName);
                        rowData.addElement(file.getName());
                        rowData.addElement(file.getPath());
                        CircRnaDataLoadDialog.this.tableData.addElement(rowData);
                        model.setDataVector(CircRnaDataLoadDialog.this.tableData, colName);
                        ++n2;
                    }
                }
            }
        });
        btClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CircRnaDataLoadDialog.this.tableData.removeAllElements();
                model.setDataVector(CircRnaDataLoadDialog.this.tableData, colName);
            }
        });
        btOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeMap<String, Gene> genes;
                DataLoadingDialog dataLoadingDialog = new DataLoadingDialog((Frame)CircView.frame, "Loading CircRNA Data ...");
                CircRnaDataLoadDialog.this.setVisible(false);
                TreeMap<String, String> uniqSpecies = new TreeMap<String, String>();
                for (Vector rowData : CircRnaDataLoadDialog.this.tableData) {
                    String speciesName = (String)rowData.get(0);
                    uniqSpecies.put(speciesName, speciesName);
                }
                boolean hasSpecies = true;
                for (String speciesName : uniqSpecies.keySet()) {
                    if (MainData.getSpeciesData().get(speciesName) != null) continue;
                    genes = new TreeMap();
                    File speciesFile = new File(MainData.getSpeciesFile().get(speciesName));
                    if (CircRnaTool.initSpeciesDataFromFile(speciesFile, genes)) {
                        MainData.getSpeciesData().put(speciesName, genes);
                        CircView.log.info((Object)(String.valueOf(speciesName) + " Data Loaded"));
                        continue;
                    }
                    hasSpecies = false;
                    JOptionPane.showMessageDialog(CircView.frame, "[" + speciesFile.getPath() + "] does NOT EXIST or file FORMAT ERROR!");
                    CircView.log.error((Object)("[" + speciesFile.getPath() + "] does NOT EXIST or file FORMAT ERROR!"));
                    dataLoadingDialog.setVisible(false);
                    CircRnaDataLoadDialog.this.dispose();
                }
                if (hasSpecies) {
                    for (String speciesName : uniqSpecies.keySet()) {
                        genes = MainData.getSpeciesData().get(speciesName);
                        try {
                            CircRnaTool.initCircRnaDataFromFiles(CircRnaDataLoadDialog.this.tableData, speciesName, genes);
                            for (Vector rowData : CircRnaDataLoadDialog.this.tableData) {
                                String sname = (String)rowData.get(0);
                                if (!sname.equalsIgnoreCase(speciesName)) continue;
                                MainData.getCircRnaFilesInfo().add(rowData);
                            }
                            CircView.updateSpeciesCombo();
                            CircView.updateCircRnaToolsCombo();
                            CircView.updateSamplesCombo();
                            CircView.updateCbChrom();
                            CircView.updateGeneTransList();
                        }
                        catch (FileReadException e1) {
                            JOptionPane.showMessageDialog(CircView.frame, e1.getMessage());
                            CircView.log.error((Object)e1.getMessage());
                            dataLoadingDialog.setVisible(false);
                            CircRnaDataLoadDialog.this.dispose();
                        }
                    }
                }
                dataLoadingDialog.setVisible(false);
                CircRnaDataLoadDialog.this.dispose();
            }
        });
    }
}

