/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.whu.ui;

import cn.edu.whu.CircRna;
import cn.edu.whu.CircView;
import cn.edu.whu.GeneTranscript;
import cn.edu.whu.util.DbUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CircRnaImagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private GeneTranscript gtBackup = null;
    private GeneTranscript gt = null;
    private int toolNum = 1;
    private int sampleNum = 1;
    private final Vector<Color> colorList;
    private int IMAGE_PANEL_WIDTH;
    private int IMAGE_PANEL_HEIGHT;
    private float zoomValue;
    private int IMAGE_MARGIN_LEFT = 20;
    private int IMAGE_MARGIN_RIGHT = 20;
    private int STRAND_ARROW_LENGTH = 20;
    private int ANNOTATION_FONT = 12;
    private int EXON_NUM_FONT = 12;
    private int CIRCRNA_INFO_FONT = 12;
    private float MRE_STROKE = 0.5f;
    private float DEFAULT_STROKE = 0.5f;
    private float INDICATION_STROKE = 0.5f;
    private int TRANSCRIPT_ANNOTATION_TOP = 20;
    private int TRANSCRIPT_IMAGE_TOP = 30;
    private int TRANSCRIPT_EXON_HEIGHT = 20;
    private int TRANSCRIPT_INTRON_HEIGHT = 1;
    private Connection conn;
    private BufferedImage circRnaImage;
    private TreeMap<String, TreeMap<String, Vector<String>>> circRnasRbp = new TreeMap();
    private TreeMap<String, TreeMap<String, Vector<String>>> circRnasMre = new TreeMap();
    private Vector<Double> circX;
    private Vector<Double> circY;
    private double circR;

    public CircRnaImagePanel() {
        this.colorList = new Vector();
        this.initColor();
        this.setBackground(Color.WHITE);
        this.circX = new Vector();
        this.circY = new Vector();
        this.circR = 0.0;
    }

    public void createOneImage(int width, int height, Connection c) {
        this.IMAGE_PANEL_WIDTH = width - 20;
        this.IMAGE_PANEL_HEIGHT = height - 50;
        this.zoomValue = 1.0f;
        this.conn = c;
        this.circRnaImage = new BufferedImage(this.IMAGE_PANEL_WIDTH, this.IMAGE_PANEL_HEIGHT, 2);
        this.setSize(new Dimension(this.IMAGE_PANEL_WIDTH, this.IMAGE_PANEL_HEIGHT));
    }

    private void initColor() {
        this.colorList.addElement(Color.ORANGE);
        this.colorList.addElement(Color.CYAN);
        this.colorList.addElement(Color.GRAY);
        this.colorList.addElement(Color.GREEN);
        this.colorList.addElement(Color.LIGHT_GRAY);
        this.colorList.addElement(Color.MAGENTA);
        this.colorList.addElement(Color.PINK);
        this.colorList.addElement(Color.RED);
        this.colorList.addElement(Color.YELLOW);
    }

    public GeneTranscript getGt() {
        return this.gt;
    }

    public void setGt(GeneTranscript gt, int sampleNum, int toolNum) {
        this.gtBackup = gt;
        this.sampleNum = sampleNum;
        this.toolNum = toolNum;
        this.gt = this.gtBackup.deepClone();
    }

    public int getToolNum() {
        return this.toolNum;
    }

    public void setToolNum(int toolNum) {
        this.toolNum = toolNum;
    }

    public int getSampleNum() {
        return this.sampleNum;
    }

    public void setSampleNum(int sampleNum) {
        this.sampleNum = sampleNum;
    }

    public void zoomIn() {
        this.zoomValue = (float)((double)this.zoomValue * 1.1);
        if (this.zoomValue > 5.0f) {
            this.zoomValue = 5.0f;
        }
        this.setSize(new Dimension((int)((float)this.IMAGE_PANEL_WIDTH * this.zoomValue), (int)((float)this.IMAGE_PANEL_HEIGHT * this.zoomValue)));
        this.circRnaImage = new BufferedImage((int)((float)this.IMAGE_PANEL_WIDTH * this.zoomValue), (int)((float)this.IMAGE_PANEL_HEIGHT * this.zoomValue), 2);
        this.repaint();
        this.revalidate();
    }

    public void zoomOut() {
        this.zoomValue = (float)((double)this.zoomValue * 0.9);
        if (this.zoomValue < 1.0f) {
            this.zoomValue = 1.0f;
        }
        this.setSize(new Dimension((int)((float)this.IMAGE_PANEL_WIDTH * this.zoomValue), (int)((float)this.IMAGE_PANEL_HEIGHT * this.zoomValue)));
        this.circRnaImage = new BufferedImage((int)((float)this.IMAGE_PANEL_WIDTH * this.zoomValue), (int)((float)this.IMAGE_PANEL_HEIGHT * this.zoomValue), 2);
        this.repaint();
        this.revalidate();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setStroke(new BasicStroke(0.5f, 0, 2));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.getGt() != null) {
            this.drawCircRnaImage(this.circRnaImage, this.gt);
            g2d.drawImage((Image)this.circRnaImage, 0, 0, this);
        }
    }

    private void initConstantValue(BufferedImage circRnaImage) {
        int baseWidth = circRnaImage.getWidth() / 50;
        int baseHeight = circRnaImage.getHeight() / 50;
        this.IMAGE_MARGIN_RIGHT = this.IMAGE_MARGIN_LEFT = baseWidth < 20 ? 20 : baseWidth;
        this.TRANSCRIPT_ANNOTATION_TOP = (int)((double)this.IMAGE_MARGIN_LEFT * 1.5);
        this.STRAND_ARROW_LENGTH = this.IMAGE_MARGIN_LEFT;
        this.TRANSCRIPT_IMAGE_TOP = (int)((double)this.TRANSCRIPT_ANNOTATION_TOP * 1.5);
        this.TRANSCRIPT_INTRON_HEIGHT = (int)Math.round((double)this.TRANSCRIPT_ANNOTATION_TOP / 40.0);
        this.TRANSCRIPT_EXON_HEIGHT = this.TRANSCRIPT_INTRON_HEIGHT * 20;
        this.INDICATION_STROKE = (float)((float)(this.TRANSCRIPT_INTRON_HEIGHT / 2) < 0.5f ? 0.5 : (double)this.TRANSCRIPT_INTRON_HEIGHT / 2.0);
        this.ANNOTATION_FONT = (int)Math.round((double)this.TRANSCRIPT_EXON_HEIGHT / 1.2);
        this.EXON_NUM_FONT = (int)Math.round((double)this.ANNOTATION_FONT / 1.5);
        this.CIRCRNA_INFO_FONT = (int)Math.round((double)this.ANNOTATION_FONT / 1.8);
    }

    @Override
    public Dimension getPreferredSize() {
        int width = 0;
        int height = 0;
        if (this != null) {
            width = this.getWidth();
            height = this.getHeight();
        }
        return new Dimension(width, height);
    }

    private void drawCircRnaImage(BufferedImage circRnaImage, GeneTranscript gt) {
        if (gt == null) {
            CircView.log.warn((Object)"Can NOT Save Image");
            return;
        }
        this.initConstantValue(circRnaImage);
        Graphics2D g2d = (Graphics2D)circRnaImage.getGraphics();
        g2d.setStroke(new BasicStroke(0.5f, 0, 2));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setBackground(Color.WHITE);
        this.drawTranscript(g2d, circRnaImage, gt);
        this.drawCircRna(g2d, circRnaImage, gt);
    }

    private void drawTranscript(Graphics2D g2d, BufferedImage circRnaImage, GeneTranscript gt) {
        this.drawAnotation(g2d, circRnaImage, gt);
        this.drawIntrons(g2d, circRnaImage, gt);
        this.drawStrand(g2d, circRnaImage, gt);
        this.drawExons(g2d, circRnaImage, gt);
    }

    private void drawAnotation(Graphics2D g2d, BufferedImage circRnaImage, GeneTranscript gt) {
        String notation = String.valueOf(gt.getGeneName()) + " [" + gt.getTranscriptName() + "]\t" + gt.getChrom() + "\t" + "Exon Number[" + gt.getExonCount() + "]\tTx[" + gt.getTxStart() + "-" + gt.getTxEnd() + "]\t" + "Cds[" + gt.getCdsStart() + "-" + gt.getCdsEnd() + "]";
        g2d.setColor(Color.BLACK);
        g2d.setFont(new Font("TimesRoman", 0, this.ANNOTATION_FONT));
        g2d.setStroke(new BasicStroke(this.DEFAULT_STROKE, 0, 2));
        g2d.drawString(notation, this.IMAGE_MARGIN_LEFT, this.TRANSCRIPT_ANNOTATION_TOP);
    }

    private void drawIntrons(Graphics2D g2d, BufferedImage circRnaImage, GeneTranscript gt) {
        double intronXPosition = this.IMAGE_MARGIN_LEFT;
        double intronYPosition = (double)this.TRANSCRIPT_IMAGE_TOP + (double)this.TRANSCRIPT_EXON_HEIGHT / 2.0;
        double drawLength = circRnaImage.getWidth() - this.IMAGE_MARGIN_LEFT - this.IMAGE_MARGIN_RIGHT;
        Rectangle2D.Double intron = new Rectangle2D.Double(intronXPosition, intronYPosition, drawLength, this.TRANSCRIPT_INTRON_HEIGHT);
        g2d.setColor(Color.BLACK);
        g2d.fill(intron);
    }

    private void drawStrand(Graphics2D g2d, BufferedImage circRnaImage, GeneTranscript gt) {
        Polygon arrow = new Polygon();
        if (gt.getStrand().equals("+")) {
            int xPosition = circRnaImage.getWidth() - this.IMAGE_MARGIN_RIGHT;
            int yPosition = this.TRANSCRIPT_IMAGE_TOP + this.TRANSCRIPT_EXON_HEIGHT / 2;
            arrow.addPoint(xPosition, yPosition);
            arrow.addPoint(xPosition - this.STRAND_ARROW_LENGTH / 2, yPosition - this.STRAND_ARROW_LENGTH / 4);
            arrow.addPoint(xPosition - this.STRAND_ARROW_LENGTH / 2, yPosition + this.STRAND_ARROW_LENGTH / 4);
        } else {
            int xPosition = this.IMAGE_MARGIN_LEFT;
            int yPosition = this.TRANSCRIPT_IMAGE_TOP + this.TRANSCRIPT_EXON_HEIGHT / 2;
            arrow.addPoint(xPosition, yPosition);
            arrow.addPoint(xPosition + this.STRAND_ARROW_LENGTH / 2, yPosition - this.STRAND_ARROW_LENGTH / 4);
            arrow.addPoint(xPosition + this.STRAND_ARROW_LENGTH / 2, yPosition + this.STRAND_ARROW_LENGTH / 4);
        }
        g2d.setColor(Color.BLACK);
        g2d.fill(arrow);
    }

    private void drawExons(Graphics2D g2d, BufferedImage circRnaImage, GeneTranscript gt) {
        long basePoint = gt.getTxStart();
        double lengthRatio = 1.0 * (double)(circRnaImage.getWidth() - this.IMAGE_MARGIN_LEFT - this.IMAGE_MARGIN_RIGHT - this.STRAND_ARROW_LENGTH) / (double)(gt.getTxEnd() - gt.getTxStart());
        double exonXPosition = 0.0;
        double exonYPosition = this.TRANSCRIPT_IMAGE_TOP;
        exonXPosition = gt.getStrand().equals("+") ? (double)this.IMAGE_MARGIN_LEFT : (double)(this.IMAGE_MARGIN_LEFT + this.STRAND_ARROW_LENGTH);
        Vector<Rectangle2D.Double> exonRects = new Vector<Rectangle2D.Double>();
        int i = 0;
        while (i < gt.getExonCount()) {
            double startPoint = (double)(gt.getExonStarts().get(i) - basePoint) * lengthRatio;
            double endPoint = (double)(gt.getExonEnds().get(i) - basePoint) * lengthRatio;
            double length = endPoint - startPoint < 1.0 ? 1.0 : endPoint - startPoint;
            Rectangle2D.Double exonRect = new Rectangle2D.Double(exonXPosition + startPoint, exonYPosition, length, this.TRANSCRIPT_EXON_HEIGHT);
            exonRects.addElement(exonRect);
            int no = 0;
            no = gt.getStrand().equals("+") ? i + 1 : gt.getExonCount() - i;
            g2d.setColor(Color.BLACK);
            g2d.setFont(new Font("TimesRoman", 0, this.EXON_NUM_FONT));
            g2d.setStroke(new BasicStroke(0.5f, 0, 2));
            if (no % 5 == 0) {
                g2d.drawString(String.valueOf(no), (int)(exonXPosition + startPoint), (int)(exonYPosition + (double)this.TRANSCRIPT_EXON_HEIGHT + (double)g2d.getFontMetrics().getHeight()));
            }
            ++i;
        }
        i = 0;
        while (i < exonRects.size()) {
            g2d.setColor(this.colorList.get(i % this.colorList.size()));
            g2d.fill((Shape)exonRects.get(i));
            ++i;
        }
    }

    private void drawCircRna(Graphics2D g2d, BufferedImage circRnaImage, GeneTranscript gt) {
        double imageWidth = circRnaImage.getWidth() - this.IMAGE_MARGIN_LEFT - this.IMAGE_MARGIN_RIGHT;
        double circImageWidth = imageWidth / (double)gt.getCircRnas().size();
        Vector<Double> centX = new Vector<Double>();
        Vector<Double> centY = new Vector<Double>();
        long firstCentX = Math.round((double)this.IMAGE_MARGIN_LEFT + circImageWidth / 2.0);
        int i = 0;
        while (i < gt.getCircRnas().size()) {
            centX.add((double)firstCentX + (double)i * circImageWidth);
            centY.add((double)circRnaImage.getHeight() / 2.0);
            ++i;
        }
        double circImageHeight = (double)circRnaImage.getHeight() / 3.0;
        double circRectLength = circImageHeight < circImageWidth ? circImageHeight : circImageWidth;
        double diameter = 8.0 * circRectLength / 10.0;
        double lineStroke = circRectLength / 10.0;
        this.setCircX(centX);
        this.setCircY(centY);
        this.setCircR(diameter / 2.0);
        int circNum = -1;
        for (String circRnaId : gt.getCircRnas().keySet()) {
            int yP2;
            int xP2;
            int yP1;
            int xP1;
            int yP;
            int xP;
            Polygon arrow;
            String intronType;
            ++circNum;
            CircRna circRna = gt.getCircRnas().get(circRnaId);
            long circStart = circRna.getStartPoint();
            long circEnd = circRna.getEndPoint();
            long circRnaLen = 0L;
            TreeMap<Integer, String> exonsInfo = new TreeMap<Integer, String>();
            Vector<Integer> exonsId = new Vector<Integer>();
            int i2 = 0;
            while (i2 < gt.getExonCount()) {
                long exonStart = gt.getExonStarts().get(i2);
                long exonEnd = gt.getExonEnds().get(i2);
                if (circStart <= exonStart && exonEnd <= circEnd) {
                    circRnaLen += exonEnd - exonStart;
                    exonsInfo.put(i2, String.valueOf(exonStart) + "-" + exonEnd);
                    exonsId.add(i2);
                } else if (exonStart < circStart && circStart < exonEnd && exonEnd <= circEnd) {
                    circRnaLen += exonEnd - circStart;
                    exonsInfo.put(i2, String.valueOf(circStart) + "-" + exonEnd);
                    exonsId.add(i2);
                } else if (circStart <= exonStart && exonStart < circEnd && circEnd < exonEnd) {
                    circRnaLen += circEnd - exonStart;
                    exonsInfo.put(i2, String.valueOf(exonStart) + "-" + circEnd);
                    exonsId.add(i2);
                } else if (exonStart < circStart && circEnd < exonEnd) {
                    circRnaLen += circEnd - circStart;
                    exonsInfo.put(i2, String.valueOf(circStart) + "-" + circEnd);
                    exonsId.add(i2);
                }
                ++i2;
            }
            double arcRatio = 360.0 / (double)circRnaLen;
            TreeMap<Integer, Integer> exonArcsDegree = new TreeMap<Integer, Integer>();
            Iterator iterator = exonsId.iterator();
            while (iterator.hasNext()) {
                int exonId = (Integer)iterator.next();
                String[] str = ((String)exonsInfo.get(exonId)).split("-");
                long start = Long.parseLong(str[0]);
                long end = Long.parseLong(str[1]);
                double degree = arcRatio * (double)(end - start);
                int exonArcDegree = (int)Math.round(degree) < 1 ? 1 : (int)Math.round(degree);
                exonArcsDegree.put(exonId, exonArcDegree);
            }
            long basePoint = gt.getTxStart();
            double lengthRatio = 1.0 * (double)(circRnaImage.getWidth() - this.IMAGE_MARGIN_LEFT - this.IMAGE_MARGIN_RIGHT - this.STRAND_ARROW_LENGTH) / (double)(gt.getTxEnd() - gt.getTxStart());
            int x = this.IMAGE_MARGIN_LEFT;
            if (gt.getStrand().equals("-")) {
                x += this.STRAND_ARROW_LENGTH;
            }
            x += (int)Math.round((double)(circRna.getStartPoint() - basePoint) * lengthRatio);
            int y = this.TRANSCRIPT_IMAGE_TOP + this.TRANSCRIPT_EXON_HEIGHT;
            g2d.setStroke(new BasicStroke(this.INDICATION_STROKE, 0, 2));
            if (exonsId.size() > 0) {
                g2d.setColor(this.colorList.get((Integer)exonsId.get(0) % this.colorList.size()));
            } else {
                g2d.setColor(Color.BLACK);
            }
            g2d.drawLine(x, y, (int)Math.round(centX.get(circNum)), (int)Math.round(centY.get(circNum)) - (int)Math.round(circRectLength / 2.0));
            x = this.IMAGE_MARGIN_LEFT;
            if (gt.getStrand().equals("-")) {
                x += this.STRAND_ARROW_LENGTH;
            }
            x += (int)Math.round((double)(circRna.getEndPoint() - basePoint) * lengthRatio);
            if (exonsId.size() > 0) {
                g2d.setColor(this.colorList.get((Integer)exonsId.get(exonsId.size() - 1) % this.colorList.size()));
            } else {
                g2d.setColor(Color.BLACK);
            }
            g2d.drawLine(x, y, (int)Math.round(centX.get(circNum)), (int)Math.round(centY.get(circNum)) - (int)Math.round(circRectLength / 2.0));
            double circX = centX.get(circNum) - diameter / 2.0;
            double circY = centY.get(circNum) - diameter / 2.0;
            if (gt.getCircRnas().get(circRnaId).getCircRnaType().equalsIgnoreCase("Exon")) {
                int startAngle = 90;
                int angle = 0;
                if (exonsId.size() > 0 && gt.getExonStarts().get((Integer)exonsId.get(0)) - 2L <= gt.getCircRnas().get(circRnaId).getStartPoint() && gt.getCircRnas().get(circRnaId).getStartPoint() <= gt.getExonEnds().get((Integer)exonsId.get(0)) + 2L && gt.getExonStarts().get((Integer)exonsId.get(exonsId.size() - 1)) - 2L <= gt.getCircRnas().get(circRnaId).getEndPoint() && gt.getCircRnas().get(circRnaId).getEndPoint() <= gt.getExonEnds().get((Integer)exonsId.get(exonsId.size() - 1)) + 2L) {
                    TreeMap<String, Vector<String>> oneCircRbp = this.circRnasRbp.get(circRnaId);
                    TreeMap<String, Vector<String>> oneCircMre = this.circRnasMre.get(circRnaId);
                    Iterator iterator2 = exonsId.iterator();
                    while (iterator2.hasNext()) {
                        Vector<String> oneExonMre;
                        int exonId = (Integer)iterator2.next();
                        angle = (Integer)exonArcsDegree.get(exonId);
                        g2d.setStroke(new BasicStroke((float)lineStroke, 0, 2));
                        g2d.setColor(this.colorList.get(exonId % this.colorList.size()));
                        g2d.drawArc((int)Math.round(circX), (int)Math.round(circY), (int)Math.round(diameter), (int)Math.round(diameter), startAngle, angle);
                        int exonNum = 1;
                        exonNum = gt.getStrand().equals("+") ? exonId + 1 : gt.getExonCount() - exonId;
                        g2d.setColor(Color.BLACK);
                        g2d.setStroke(new BasicStroke(this.DEFAULT_STROKE, 0, 2));
                        String[] tmp = ((String)exonsInfo.get(exonId)).split("-");
                        int exonLen = Integer.parseInt(tmp[1]) - Integer.parseInt(tmp[0]);
                        g2d.setFont(new Font("TimesRoman", 0, (int)Math.round(diameter / 18.0)));
                        g2d.drawString(String.valueOf(exonNum) + "(" + exonLen + ")", (int)(centX.get(circNum) - lineStroke / 4.0 + diameter / 2.0 * Math.cos((double)((startAngle + angle / 2) % 360) * Math.PI / 180.0)), (int)(centY.get(circNum) + lineStroke / 4.0 - diameter / 2.0 * Math.sin((double)((startAngle + angle / 2) % 360) * Math.PI / 180.0)));
                        if (oneCircRbp != null) {
                            int rbpHeight = (int)Math.round(lineStroke);
                            Vector<String> oneExonRbp = oneCircRbp.get(gt.getExonStarts().get(exonId) + "-" + gt.getExonEnds().get(exonId));
                            if (oneExonRbp != null) {
                                int r = 0;
                                while (r < oneExonRbp.size()) {
                                    String[] item = oneExonRbp.get(r).split("\t");
                                    double exonRelatePos = Double.parseDouble(item[5]);
                                    double rbpPositionAngle = ((double)startAngle + (double)angle * exonRelatePos) % 360.0;
                                    int rbpX = (int)Math.round(centX.get(circNum) + (diameter + lineStroke) / 2.0 * Math.cos(rbpPositionAngle / 180.0 * Math.PI) + lineStroke / 2.0);
                                    int rbpY = (int)Math.round(centY.get(circNum) - (diameter + lineStroke) / 2.0 * Math.sin(rbpPositionAngle / 180.0 * Math.PI) + lineStroke / 2.0);
                                    this.drawRBP(g2d, rbpX, rbpY, (int)Math.round(rbpPositionAngle), rbpHeight);
                                    ++r;
                                }
                            }
                        }
                        if (oneCircMre != null && (oneExonMre = oneCircMre.get(gt.getExonStarts().get(exonId) + "-" + gt.getExonEnds().get(exonId))) != null) {
                            int r = 0;
                            while (r < oneExonMre.size()) {
                                String[] item = oneExonMre.get(r).split("\t");
                                double exonRelatePos = Double.parseDouble(item[5]);
                                double mrePositionAngle = ((double)startAngle + (double)angle * exonRelatePos) % 360.0;
                                int mreX1 = (int)Math.round(centX.get(circNum) + (diameter - lineStroke) / 2.0 * Math.cos(mrePositionAngle / 180.0 * Math.PI));
                                int mreY1 = (int)Math.round(centY.get(circNum) - (diameter - lineStroke) / 2.0 * Math.sin(mrePositionAngle / 180.0 * Math.PI));
                                int mreX2 = (int)Math.round(centX.get(circNum) + (diameter / 2.0 - lineStroke) * Math.cos(mrePositionAngle / 180.0 * Math.PI));
                                int mreY2 = (int)Math.round(centY.get(circNum) - (diameter / 2.0 - lineStroke) * Math.sin(mrePositionAngle / 180.0 * Math.PI));
                                this.drawMre(g2d, mreX1, mreY1, mreX2, mreY2);
                                ++r;
                            }
                        }
                        startAngle += angle;
                        startAngle %= 360;
                    }
                } else if (exonArcsDegree.size() > 0) {
                    Iterator oneCircMre = exonsId.iterator();
                    while (oneCircMre.hasNext()) {
                        int exonId = (Integer)oneCircMre.next();
                        angle = (Integer)exonArcsDegree.get(exonId);
                        g2d.setStroke(new BasicStroke((float)lineStroke, 0, 2));
                        g2d.setColor(this.colorList.get(exonId % this.colorList.size()));
                        g2d.drawArc((int)Math.round(circX), (int)Math.round(circY), (int)Math.round(diameter), (int)Math.round(diameter), startAngle, (int)Math.round((double)angle / 2.0));
                        g2d.setStroke(new BasicStroke(this.TRANSCRIPT_INTRON_HEIGHT, 0, 2));
                        g2d.setColor(Color.BLACK);
                        g2d.drawArc((int)Math.round(circX), (int)Math.round(circY), (int)Math.round(diameter), (int)Math.round(diameter), (startAngle + (int)Math.round((double)angle / 2.0)) % 360, (int)Math.round((double)angle / 2.0));
                        int exonNum = 1;
                        exonNum = gt.getStrand().equals("+") ? exonId + 1 : gt.getExonCount() - exonId;
                        g2d.setColor(Color.BLACK);
                        g2d.setStroke(new BasicStroke(this.DEFAULT_STROKE, 0, 2));
                        String[] tmp = ((String)exonsInfo.get(exonId)).split("-");
                        int exonLen = Integer.parseInt(tmp[1]) - Integer.parseInt(tmp[0]);
                        g2d.setFont(new Font("TimesRoman", 0, (int)Math.round(diameter / 18.0)));
                        g2d.drawString(String.valueOf(exonNum) + "(" + exonLen + ")", (int)(centX.get(circNum) - lineStroke / 4.0 + diameter / 2.0 * Math.cos((double)((startAngle + angle / 4) % 360) * Math.PI / 180.0)), (int)(centY.get(circNum) + lineStroke / 4.0 - diameter / 2.0 * Math.sin((double)((startAngle + angle / 4) % 360) * Math.PI / 180.0)));
                        startAngle += angle;
                        startAngle %= 360;
                    }
                } else {
                    String intronType2 = "Intron";
                    g2d.setColor(Color.BLACK);
                    g2d.setStroke(new BasicStroke(this.DEFAULT_STROKE, 0, 2));
                    g2d.setFont(new Font("TimesRoman", 0, (int)Math.round(diameter / 16.0)));
                    g2d.drawString(intronType2, (int)Math.round(centX.get(circNum)) - g2d.getFontMetrics().stringWidth(intronType2) / 2, (int)((double)Math.round(centY.get(circNum)) - diameter / 5.0));
                    g2d.setStroke(new BasicStroke(this.TRANSCRIPT_INTRON_HEIGHT, 0, 2));
                    g2d.drawArc((int)Math.round(circX), (int)Math.round(circY), (int)Math.round(diameter), (int)Math.round(diameter), 0, 360);
                }
            } else if (gt.getCircRnas().get(circRnaId).getCircRnaType().equalsIgnoreCase("Intron")) {
                intronType = "Intron";
                g2d.setColor(Color.BLACK);
                g2d.setStroke(new BasicStroke(this.DEFAULT_STROKE, 0, 2));
                g2d.setFont(new Font("TimesRoman", 0, (int)Math.round(diameter / 16.0)));
                g2d.drawString(intronType, (int)Math.round(centX.get(circNum) - (double)g2d.getFontMetrics().stringWidth(intronType) / 2.0), (int)((double)Math.round(centY.get(circNum)) - diameter / 5.0));
                g2d.setStroke(new BasicStroke(this.TRANSCRIPT_INTRON_HEIGHT, 0, 2));
                g2d.drawArc((int)Math.round(centX.get(circNum) - diameter / 2.0), (int)Math.round(centY.get(circNum) - diameter / 2.0), (int)Math.round(diameter), (int)Math.round(diameter), 0, 360);
            } else if (gt.getCircRnas().get(circRnaId).getCircRnaType().equalsIgnoreCase("Intergenic")) {
                intronType = "Intergenic";
                g2d.setColor(Color.RED);
                g2d.setStroke(new BasicStroke(this.DEFAULT_STROKE, 0, 2));
                g2d.setFont(new Font("TimesRoman", 0, (int)Math.round(diameter / 16.0)));
                g2d.drawString(intronType, (int)Math.round(centX.get(circNum)) - (int)Math.round((double)g2d.getFontMetrics().stringWidth(intronType) / 2.0), (int)((double)Math.round(centY.get(circNum)) - diameter / 5.0));
                g2d.setStroke(new BasicStroke(this.TRANSCRIPT_INTRON_HEIGHT, 0, 2));
                g2d.drawArc((int)Math.round(centX.get(circNum) - diameter / 2.0), (int)Math.round(centY.get(circNum) - diameter / 2.0), (int)Math.round(diameter), (int)Math.round(diameter), 0, 360);
            } else {
                g2d.setColor(Color.RED);
            }
            this.CIRCRNA_INFO_FONT = (int)Math.round(diameter / 15.0);
            g2d.setFont(new Font("TimesRoman", 0, this.CIRCRNA_INFO_FONT));
            g2d.setColor(Color.BLACK);
            g2d.setStroke(new BasicStroke(this.DEFAULT_STROKE, 0, 2));
            g2d.setFont(new Font("TimesRoman", 0, (int)Math.round(diameter / 14.0)));
            g2d.drawString(circRnaId.replace("|", "-"), (int)Math.round(centX.get(circNum) - (double)g2d.getFontMetrics().stringWidth(circRnaId) / 2.0), (int)Math.round(centY.get(circNum) + circRectLength / 2.0) + this.ANNOTATION_FONT);
            this.CIRCRNA_INFO_FONT = (int)Math.round(diameter / 16.0);
            g2d.setFont(new Font("TimesRoman", 0, this.CIRCRNA_INFO_FONT));
            String recSample = "recurrent sample:" + circRna.getSamples().size() + "/" + this.sampleNum + "=" + Math.round(100.0 * (double)circRna.getSamples().size() / (double)this.sampleNum) + "%";
            String recTool = "overlap tool:" + circRna.getCircTools().size() + "/" + this.toolNum + "=" + Math.round(100.0 * (double)circRna.getCircTools().size() / (double)this.toolNum) + "%";
            String junctionReads = "max abundance:" + circRna.getJunctionReads();
            g2d.setFont(new Font("TimesRoman", 0, (int)Math.round(diameter / 16.0)));
            g2d.drawString(recSample, (int)Math.round(centX.get(circNum) - (double)g2d.getFontMetrics().stringWidth(recSample) / 2.0), (int)Math.round(centY.get(circNum) - diameter / 10.0));
            g2d.drawString(recTool, (int)Math.round(centX.get(circNum) - (double)g2d.getFontMetrics().stringWidth(recTool) / 2.0), (int)Math.round(centY.get(circNum)));
            g2d.drawString(junctionReads, (int)Math.round(centX.get(circNum) - (double)g2d.getFontMetrics().stringWidth(junctionReads) / 2.0), (int)Math.round(centY.get(circNum) + diameter / 10.0));
            g2d.setStroke(new BasicStroke((float)lineStroke, 0, 2));
            g2d.drawArc((int)Math.round(centX.get(circNum) - diameter / 2.0), (int)Math.round(centY.get(circNum) - diameter / 2.0), (int)Math.round(diameter), (int)Math.round(diameter), 90, 1);
            g2d.setStroke(new BasicStroke(this.DEFAULT_STROKE, 0, 2));
            g2d.drawArc((int)Math.round(centX.get(circNum) - diameter / 2.0), (int)Math.round(centY.get(circNum) - diameter / 2.0), (int)Math.round(diameter), (int)Math.round(diameter), 0, 360);
            double thick = lineStroke / 4.0;
            double r = diameter / 2.0;
            if (gt.getCircRnas().get(circRnaId).getStrand().equals("+")) {
                arrow = new Polygon();
                xP = (int)Math.round(centX.get(circNum));
                yP = (int)(centY.get(circNum) - r);
                xP1 = (int)Math.round(centX.get(circNum) + (r - thick) * Math.sin(0.1111111111111111));
                yP1 = (int)Math.round(centY.get(circNum) - (r - thick) * Math.cos(0.1111111111111111));
                xP2 = (int)Math.round(centX.get(circNum) + (r + thick) * Math.sin(0.1111111111111111));
                yP2 = (int)Math.round(centY.get(circNum) - (r + thick) * Math.cos(0.1111111111111111));
                arrow.addPoint(xP, yP);
                arrow.addPoint(xP1, yP1);
                arrow.addPoint(xP2, yP2);
                g2d.setColor(Color.BLACK);
                g2d.fill(arrow);
                arrow = new Polygon();
                xP = (int)Math.round(centX.get(circNum));
                yP = (int)(centY.get(circNum) + r);
                xP1 = (int)Math.round(centX.get(circNum) - (r - thick) * Math.sin(0.1111111111111111));
                yP1 = (int)Math.round(centY.get(circNum) + (r - thick) * Math.cos(0.1111111111111111));
                xP2 = (int)Math.round(centX.get(circNum) - (r + thick) * Math.sin(0.1111111111111111));
                yP2 = (int)Math.round(centY.get(circNum) + (r + thick) * Math.cos(0.1111111111111111));
                arrow.addPoint(xP, yP);
                arrow.addPoint(xP1, yP1);
                arrow.addPoint(xP2, yP2);
                g2d.setColor(Color.BLACK);
                g2d.fill(arrow);
                continue;
            }
            arrow = new Polygon();
            xP = (int)Math.round(centX.get(circNum));
            yP = (int)(centY.get(circNum) - r);
            xP1 = (int)Math.round(centX.get(circNum) - (r - thick) * Math.sin(0.1111111111111111));
            yP1 = (int)Math.round(centY.get(circNum) - (r - thick) * Math.cos(0.1111111111111111));
            xP2 = (int)Math.round(centX.get(circNum) - (r + thick) * Math.sin(0.1111111111111111));
            yP2 = (int)Math.round(centY.get(circNum) - (r + thick) * Math.cos(0.1111111111111111));
            arrow.addPoint(xP, yP);
            arrow.addPoint(xP1, yP1);
            arrow.addPoint(xP2, yP2);
            g2d.setColor(Color.BLACK);
            g2d.fill(arrow);
            arrow = new Polygon();
            xP = (int)Math.round(centX.get(circNum));
            yP = (int)(centY.get(circNum) + r);
            xP1 = (int)Math.round(centX.get(circNum) + (r - thick) * Math.sin(0.1111111111111111));
            yP1 = (int)Math.round(centY.get(circNum) + (r - thick) * Math.cos(0.1111111111111111));
            xP2 = (int)Math.round(centX.get(circNum) + (r + thick) * Math.sin(0.1111111111111111));
            yP2 = (int)Math.round(centY.get(circNum) + (r + thick) * Math.cos(0.1111111111111111));
            arrow.addPoint(xP, yP);
            arrow.addPoint(xP1, yP1);
            arrow.addPoint(xP2, yP2);
            g2d.setColor(Color.BLACK);
            g2d.fill(arrow);
        }
    }

    public void selectOneCircRna(String circRnaId) {
        this.gt = this.gtBackup.deepClone();
        Iterator<String> it = this.gt.getCircRnas().keySet().iterator();
        while (it.hasNext()) {
            String id = it.next();
            if (id.equalsIgnoreCase(circRnaId)) continue;
            it.remove();
        }
    }

    public void selectAllCircRnas() {
        this.gt = this.gtBackup.deepClone();
    }

    private void drawRBP(Graphics2D g2d, int centX, int centY, int angle, int height) {
        g2d.setColor(Color.RED);
        g2d.setStroke(new BasicStroke(this.DEFAULT_STROKE, 0, 2));
        g2d.fillArc(centX - height, centY - height, height, height, angle - 15, 30);
    }

    private void drawMre(Graphics2D g2d, int x1, int y1, int x2, int y2) {
        g2d.setColor(Color.BLUE);
        g2d.setStroke(new BasicStroke(this.MRE_STROKE, 0, 2));
        g2d.drawLine(x1, y1, x2, y2);
    }

    public void saveImage(GeneTranscript gt, File outFile, String type, int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 2);
        this.drawCircRnaImage(image, gt);
        Graphics2D g2d = image.createGraphics();
        g2d.drawImage((Image)image, 0, 0, this);
        try {
            ImageIO.write((RenderedImage)image, type, outFile);
            JOptionPane.showMessageDialog(CircView.frame, "Save Image Successfully!");
        }
        catch (IOException e) {
            CircView.log.warn((Object)e.getMessage());
        }
    }

    public void queryRbpData(String species, GeneTranscript gt) {
        TreeMap<String, String> queryItem = new TreeMap<String, String>();
        for (String circRnaId : gt.getCircRnas().keySet()) {
            CircRna circRna = gt.getCircRnas().get(circRnaId);
            long start = circRna.getStartPoint();
            long end = circRna.getEndPoint();
            int j = 0;
            while (j < gt.getExonCount()) {
                long actualStart = -1L;
                long actualEnd = -1L;
                long exonStart = gt.getExonStarts().get(j);
                long exonEnd = gt.getExonEnds().get(j);
                if (start <= exonStart && exonEnd <= end) {
                    actualStart = exonStart;
                    actualEnd = exonEnd;
                } else if (exonStart < start && start < exonEnd && exonEnd <= end) {
                    actualStart = start;
                    actualEnd = exonEnd;
                } else if (start <= exonStart && exonStart < end && end < exonEnd) {
                    actualStart = exonStart;
                    actualEnd = end;
                } else if (exonStart < start && end < exonEnd) {
                    actualStart = start;
                    actualEnd = end;
                }
                if (actualStart > 0L) {
                    queryItem.put(String.valueOf(actualStart) + "-" + actualEnd, String.valueOf(exonStart) + "-" + exonEnd);
                }
                ++j;
            }
        }
        Vector<Long> starts = new Vector<Long>();
        Vector<Long> ends = new Vector<Long>();
        for (String startEnd : queryItem.keySet()) {
            String[] tmp = startEnd.split("-");
            starts.add(Long.parseLong(tmp[0]));
            ends.add(Long.parseLong(tmp[1]));
        }
        Vector<Object> queryResult = new Vector();
        try {
            String tableName = "rbp_" + DbUtil.species2TableName(species);
            queryResult = DbUtil.selectRbp(this.conn, tableName, gt.getChrom(), starts, ends);
            if (queryResult == null) {
                return;
            }
        }
        catch (SQLException e) {
            CircView.log.warn((Object)e.getMessage());
        }
        for (String circRnaId : gt.getCircRnas().keySet()) {
            CircRna circRna = gt.getCircRnas().get(circRnaId);
            long start = circRna.getStartPoint();
            long end = circRna.getEndPoint();
            TreeMap oneCircRbp = new TreeMap();
            int j = 0;
            while (j < gt.getExonCount()) {
                Vector<String> oneExonRbp = null;
                long actualStart = -1L;
                long actualEnd = -1L;
                long exonStart = gt.getExonStarts().get(j);
                long exonEnd = gt.getExonEnds().get(j);
                if (start <= exonStart && exonEnd <= end) {
                    actualStart = exonStart;
                    actualEnd = exonEnd;
                } else if (exonStart < start && start < exonEnd && exonEnd <= end) {
                    actualStart = start;
                    actualEnd = exonEnd;
                } else if (start <= exonStart && exonStart < end && end < exonEnd) {
                    actualStart = exonStart;
                    actualEnd = end;
                } else if (exonStart < start && end < exonEnd) {
                    actualStart = start;
                    actualEnd = end;
                }
                int r = 0;
                while (r < queryResult.size()) {
                    String oneRbp = (String)queryResult.get(r);
                    String[] tmp = oneRbp.split("\t");
                    long rbpStart = Long.parseLong(tmp[1]);
                    long rbpEnd = Long.parseLong(tmp[2]);
                    if (actualStart <= rbpStart && rbpEnd <= actualEnd) {
                        oneRbp = String.valueOf(oneRbp) + "\t" + 1.0 * (double)(rbpStart - actualStart) / (double)(actualEnd - actualStart);
                        if (oneExonRbp == null) {
                            oneExonRbp = new Vector<String>();
                        }
                        oneExonRbp.addElement(oneRbp);
                    }
                    ++r;
                }
                if (oneExonRbp != null) {
                    oneCircRbp.put(String.valueOf(actualStart) + "-" + actualEnd, oneExonRbp);
                }
                ++j;
            }
            this.circRnasRbp.put(circRnaId, oneCircRbp);
        }
    }

    public void queryMreData(String species, GeneTranscript gt) {
        TreeMap<String, String> queryItem = new TreeMap<String, String>();
        for (String circRnaId : gt.getCircRnas().keySet()) {
            CircRna circRna = gt.getCircRnas().get(circRnaId);
            long start = circRna.getStartPoint();
            long end = circRna.getEndPoint();
            int j = 0;
            while (j < gt.getExonCount()) {
                long actualStart = -1L;
                long actualEnd = -1L;
                long exonStart = gt.getExonStarts().get(j);
                long exonEnd = gt.getExonEnds().get(j);
                if (start <= exonStart && exonEnd <= end) {
                    actualStart = exonStart;
                    actualEnd = exonEnd;
                } else if (exonStart < start && start < exonEnd && exonEnd <= end) {
                    actualStart = start;
                    actualEnd = exonEnd;
                } else if (start <= exonStart && exonStart < end && end < exonEnd) {
                    actualStart = exonStart;
                    actualEnd = end;
                } else if (exonStart < start && end < exonEnd) {
                    actualStart = start;
                    actualEnd = end;
                }
                if (actualStart > 0L) {
                    queryItem.put(String.valueOf(actualStart) + "-" + actualEnd, String.valueOf(exonStart) + "-" + exonEnd);
                }
                ++j;
            }
        }
        Vector<Long> starts = new Vector<Long>();
        Vector<Long> ends = new Vector<Long>();
        for (String startEnd : queryItem.keySet()) {
            String[] tmp = startEnd.split("-");
            starts.add(Long.parseLong(tmp[0]));
            ends.add(Long.parseLong(tmp[1]));
        }
        Vector<Object> queryResult = new Vector();
        try {
            String tableName = "mre_" + DbUtil.species2TableName(species);
            queryResult = DbUtil.selectMre(this.conn, tableName, gt.getChrom(), starts, ends);
            if (queryResult == null) {
                return;
            }
        }
        catch (SQLException e) {
            CircView.log.warn((Object)e.getMessage());
        }
        for (String circRnaId : gt.getCircRnas().keySet()) {
            CircRna circRna = gt.getCircRnas().get(circRnaId);
            long start = circRna.getStartPoint();
            long end = circRna.getEndPoint();
            TreeMap oneCircMre = new TreeMap();
            int j = 0;
            while (j < gt.getExonCount()) {
                Vector<String> oneExonMre = null;
                long actualStart = -1L;
                long actualEnd = -1L;
                long exonStart = gt.getExonStarts().get(j);
                long exonEnd = gt.getExonEnds().get(j);
                if (start <= exonStart && exonEnd <= end) {
                    actualStart = exonStart;
                    actualEnd = exonEnd;
                } else if (exonStart < start && start < exonEnd && exonEnd <= end) {
                    actualStart = start;
                    actualEnd = exonEnd;
                } else if (start <= exonStart && exonStart < end && end < exonEnd) {
                    actualStart = exonStart;
                    actualEnd = end;
                } else if (exonStart < start && end < exonEnd) {
                    actualStart = start;
                    actualEnd = end;
                }
                int r = 0;
                while (r < queryResult.size()) {
                    String oneMre = (String)queryResult.get(r);
                    String[] tmp = oneMre.split("\t");
                    long mreStart = Long.parseLong(tmp[1]);
                    long mreEnd = Long.parseLong(tmp[2]);
                    if (actualStart <= mreStart && mreEnd <= actualEnd) {
                        oneMre = String.valueOf(oneMre) + "\t" + 1.0 * (double)(mreStart - actualStart) / (double)(actualEnd - actualStart);
                        if (oneExonMre == null) {
                            oneExonMre = new Vector<String>();
                        }
                        oneExonMre.addElement(oneMre);
                    }
                    ++r;
                }
                if (oneExonMre != null) {
                    oneCircMre.put(String.valueOf(actualStart) + "-" + actualEnd, oneExonMre);
                }
                ++j;
            }
            this.circRnasMre.put(circRnaId, oneCircMre);
        }
    }

    public void clearRbp() {
        this.circRnasRbp.clear();
    }

    public void clearMre() {
        this.circRnasMre.clear();
    }

    public String getDetails(GeneTranscript gt) {
        String details = "";
        if (gt != null) {
            int j;
            String[] item;
            int i;
            details = String.valueOf(details) + "########## Gene Transcript ##########\n";
            details = String.valueOf(details) + gt.getGeneName() + "\t" + gt.getTranscriptName() + "\t" + gt.getChrom() + "\t" + gt.getStrand() + "\t" + gt.getTotalJunctionReads() + "\t" + gt.getTxStart() + "\t" + gt.getTxEnd() + "\t" + gt.getCdsStart() + "\t" + gt.getCdsEnd() + "\t" + gt.getExonCount() + "\t";
            int i2 = 0;
            while (i2 < gt.getExonCount()) {
                details = String.valueOf(details) + gt.getExonStarts().get(i2) + ",";
                ++i2;
            }
            details = String.valueOf(details) + "\t";
            i2 = 0;
            while (i2 < gt.getExonCount()) {
                details = String.valueOf(details) + gt.getExonEnds().get(i2) + ",";
                ++i2;
            }
            details = String.valueOf(details) + "\n\n";
            details = String.valueOf(details) + "########## CircRNA ##########\n";
            for (String circRnaId : gt.getCircRnas().keySet()) {
                CircRna circRna = gt.getCircRnas().get(circRnaId);
                details = String.valueOf(details) + circRna.getChrom() + "\t" + circRna.getStartPoint() + "\t" + circRna.getEndPoint() + "\t" + circRna.getStrand() + "\t" + circRna.getJunctionReads() + "\t" + circRna.getCircRnaType() + "\t" + circRna.getRegion() + "\t";
                for (String sampleName : circRna.getSamples().keySet()) {
                    details = String.valueOf(details) + sampleName + ',';
                }
                details = String.valueOf(details) + "\t";
                for (String circTool : circRna.getCircTools().keySet()) {
                    details = String.valueOf(details) + circTool + ',';
                }
                details = String.valueOf(details) + "\t";
                for (String fileName : circRna.getFiles().keySet()) {
                    details = String.valueOf(details) + fileName + ',';
                }
                details = String.valueOf(details) + "\n";
            }
            details = String.valueOf(details) + "\n";
            if (this.circRnasRbp.size() > 0) {
                details = String.valueOf(details) + "########## RBP ##########\n";
                for (String circRnaId : gt.getCircRnas().keySet()) {
                    TreeMap<String, Vector<String>> oneCircRnaRbp = this.circRnasRbp.get(circRnaId);
                    if (oneCircRnaRbp == null) continue;
                    for (String exonId : oneCircRnaRbp.keySet()) {
                        Vector<String> oneExonRbp = oneCircRnaRbp.get(exonId);
                        i = 0;
                        while (i < oneExonRbp.size()) {
                            item = oneExonRbp.get(i).split("\t");
                            j = 0;
                            while (j < item.length - 1) {
                                details = String.valueOf(details) + item[j] + "\t";
                                ++j;
                            }
                            details = String.valueOf(details) + "\n";
                            ++i;
                        }
                    }
                }
                details = String.valueOf(details) + "\n";
            }
            if (this.circRnasMre.size() > 0) {
                details = String.valueOf(details) + "########## MRE ##########\n";
                for (String circRnaId : gt.getCircRnas().keySet()) {
                    TreeMap<String, Vector<String>> oneCircRnaMre = this.circRnasMre.get(circRnaId);
                    if (oneCircRnaMre == null) continue;
                    for (String exonId : oneCircRnaMre.keySet()) {
                        Vector<String> oneExonMre = oneCircRnaMre.get(exonId);
                        i = 0;
                        while (i < oneExonMre.size()) {
                            item = oneExonMre.get(i).split("\t");
                            j = 0;
                            while (j < item.length - 1) {
                                details = String.valueOf(details) + item[j] + "\t";
                                ++j;
                            }
                            details = String.valueOf(details) + "\n";
                            ++i;
                        }
                    }
                }
            }
        }
        return details;
    }

    public String getCircRnaInfo(String circRnaId) {
        String details = "";
        CircRna circRna = this.gt.getCircRnas().get(circRnaId);
        if (circRna != null) {
            details = String.valueOf(details) + circRna.getChrom() + "\t" + circRna.getStartPoint() + "\t" + circRna.getEndPoint() + "\t" + circRna.getStrand() + "\t" + circRna.getJunctionReads() + "\n";
            details = String.valueOf(details) + "Exon: ";
            Vector<Integer> index = new Vector<Integer>();
            int i = 0;
            while (i < this.gt.getExonStarts().size()) {
                if (circRna.getStartPoint() <= this.gt.getExonStarts().get(i) && this.gt.getExonEnds().get(i) <= circRna.getEndPoint()) {
                    index.addElement(i);
                } else if (this.gt.getExonStarts().get(i) <= circRna.getStartPoint() && circRna.getStartPoint() <= this.gt.getExonEnds().get(i)) {
                    index.addElement(i);
                } else if (this.gt.getExonStarts().get(i) <= circRna.getEndPoint() && circRna.getEndPoint() <= this.gt.getExonEnds().get(i)) {
                    index.addElement(i);
                }
                ++i;
            }
            Iterator<Object> iterator = index.iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                details = String.valueOf(details) + this.gt.getExonStarts().get(i) + ",";
            }
            details = String.valueOf(details) + "\t";
            iterator = index.iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                details = String.valueOf(details) + this.gt.getExonEnds().get(i) + ",";
            }
            details = String.valueOf(details) + "\n";
            details = String.valueOf(details) + "Type: " + circRna.getCircRnaType() + "\n";
            details = String.valueOf(details) + "Region: " + circRna.getRegion() + "\n";
            details = String.valueOf(details) + "Sample: ";
            for (String sampleName : circRna.getSamples().keySet()) {
                details = String.valueOf(details) + sampleName + ',';
            }
            details = String.valueOf(details) + "\n";
            details = String.valueOf(details) + "Tool: ";
            for (String circTool : circRna.getCircTools().keySet()) {
                details = String.valueOf(details) + circTool + ',';
            }
            details = String.valueOf(details) + "\n";
            details = String.valueOf(details) + "File: ";
            for (String fileName : circRna.getFiles().keySet()) {
                details = String.valueOf(details) + fileName + ',';
            }
            details = String.valueOf(details) + "\n";
        }
        return details;
    }

    public boolean isContainRbp() {
        return this.circRnasRbp.size() > 0;
    }

    public boolean isContainMre() {
        return this.circRnasMre.size() > 0;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public BufferedImage getCircRnaImage() {
        return this.circRnaImage;
    }

    public void setCircRnaImage(BufferedImage circRnaImage) {
        this.circRnaImage = circRnaImage;
    }

    public TreeMap<String, TreeMap<String, Vector<String>>> getCircRnasRbp() {
        return this.circRnasRbp;
    }

    public void setCircRnasRbp(TreeMap<String, TreeMap<String, Vector<String>>> circRnasRbp) {
        this.circRnasRbp = circRnasRbp;
    }

    public TreeMap<String, TreeMap<String, Vector<String>>> getCircRnasMre() {
        return this.circRnasMre;
    }

    public void setCircRnasMre(TreeMap<String, TreeMap<String, Vector<String>>> circRnasMre) {
        this.circRnasMre = circRnasMre;
    }

    public GeneTranscript getGtBackup() {
        return this.gtBackup;
    }

    public Vector<Double> getCircX() {
        return this.circX;
    }

    public void setCircX(Vector<Double> circX) {
        this.circX = circX;
    }

    public Vector<Double> getCircY() {
        return this.circY;
    }

    public void setCircY(Vector<Double> circY) {
        this.circY = circY;
    }

    public double getCircR() {
        return this.circR;
    }

    public void setCircR(double circR) {
        this.circR = circR;
    }
}

