/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.whu.ui;

import cn.edu.whu.CircView;
import cn.edu.whu.MainData;
import com.mysql.jdbc.StringUtils;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class CircRnaToolAddDialog
extends JDialog {
    private static final long serialVersionUID = 1L;

    public CircRnaToolAddDialog() {
        super(CircView.frame);
        this.initUi();
        this.setTitle("Add CircRNA Tools Name");
        this.setResizable(false);
        this.setSize(400, 65);
        this.setLayout(new FlowLayout());
        this.centerScreen();
    }

    private void centerScreen() {
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
        super.setVisible(true);
        this.requestFocus();
    }

    private void initUi() {
        final JTextField tfTools = new JTextField();
        JLabel lbAdd = new JLabel("->");
        final JComboBox<String> cbTools = new JComboBox<String>();
        JButton btAdd = new JButton("Add");
        cbTools.setPreferredSize(new Dimension(150, 28));
        for (String toolName : MainData.getCircRnaToolNames()) {
            cbTools.addItem(toolName);
        }
        tfTools.setPreferredSize(new Dimension(120, 28));
        this.getContentPane().add(tfTools);
        this.getContentPane().add(lbAdd);
        this.getContentPane().add(cbTools);
        this.getContentPane().add(btAdd);
        btAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newTool = tfTools.getText();
                if (StringUtils.isEmptyOrWhitespaceOnly((String)newTool)) {
                    JOptionPane.showMessageDialog(CircRnaToolAddDialog.this, "CircRNA Tool Name is Needed", "warning", 0);
                    return;
                }
                boolean existed = false;
                for (String oldTool : MainData.getCircRnaToolNames()) {
                    if (!newTool.equals(oldTool)) continue;
                    existed = true;
                }
                if (existed) {
                    JOptionPane.showMessageDialog(CircRnaToolAddDialog.this, "CircRNA Tools already exsits", "warning", 0);
                } else {
                    MainData.getCircRnaToolNames().add(newTool);
                    cbTools.addItem(newTool);
                    tfTools.setText("");
                    MainData.writeDbConfig();
                    CircView.log.info((Object)("New CircRnaTool [" + newTool + "] Added."));
                }
            }
        });
    }
}

