/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.whu.ui;

import cn.edu.whu.CircRna;
import cn.edu.whu.CircView;
import cn.edu.whu.Gene;
import cn.edu.whu.GeneTranscript;
import cn.edu.whu.MainData;
import cn.edu.whu.ui.CsvSaveFileChooser;
import cn.edu.whu.util.EvenOddRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ComparisonFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JComboBox<String> cbSpecies;
    private JComboBox<String> cbTolerate;
    private JList<String> jlUnSelected;
    private JList<String> jlSelected;
    private Vector<String> unSelected;
    private Vector<String> selected;
    private JScrollPane scrollUnSelected;
    private JScrollPane scrollSelected;
    private DefaultTableModel model;
    private JTable tbResult;
    private Vector<String> colName;
    private Vector<Vector<String>> tableData;
    Dimension screenSize;

    public ComparisonFrame() {
        this.setExtendedState(6);
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.setResizable(true);
        this.setTitle("Comparison Setting");
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(0, 100, (int)this.screenSize.getWidth(), (int)this.screenSize.getHeight() - 100);
        this.centerScreen();
        this.initUi();
    }

    private void centerScreen() {
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
        super.setVisible(true);
        this.requestFocus();
    }

    private void initUi() {
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BorderLayout());
        JPanel jpWest = new JPanel();
        jpWest.setLayout(new BoxLayout(jpWest, 1));
        this.cbSpecies = new JComboBox();
        this.cbSpecies.setPreferredSize(new Dimension(200, 28));
        JPanel jpTmp = new JPanel();
        JLabel lbTolerate = new JLabel("Compare Overlap");
        this.cbTolerate = new JComboBox();
        this.cbTolerate.setPreferredSize(new Dimension(80, 28));
        JLabel lbBp = new JLabel("bp");
        jpTmp.add(lbTolerate);
        jpTmp.add(this.cbTolerate);
        jpTmp.add(lbBp);
        jpWest.add(new JLabel(" "));
        jpWest.add(this.cbSpecies);
        jpWest.add(jpTmp);
        northPanel.add((Component)jpWest, "West");
        JPanel jpCenter = new JPanel();
        jpCenter.setLayout(new BoxLayout(jpCenter, 0));
        JLabel lbUnSelected = new JLabel("Sample List");
        JLabel lbSelected = new JLabel("Sample selected");
        this.jlUnSelected = new JList();
        this.jlSelected = new JList();
        this.unSelected = new Vector();
        this.selected = new Vector();
        this.jlUnSelected.setSelectionMode(2);
        this.jlSelected.setSelectionMode(2);
        this.scrollUnSelected = new JScrollPane(this.jlUnSelected);
        this.scrollSelected = new JScrollPane(this.jlSelected);
        this.scrollUnSelected.setPreferredSize(new Dimension(jpCenter.getWidth() / 2, 100));
        this.scrollSelected.setPreferredSize(new Dimension(jpCenter.getWidth() / 2, 100));
        JPanel jpLeft = new JPanel();
        JPanel jpRight = new JPanel();
        jpLeft.setLayout(new BoxLayout(jpLeft, 1));
        jpRight.setLayout(new BoxLayout(jpRight, 1));
        jpLeft.add(lbUnSelected);
        jpLeft.add(this.scrollUnSelected);
        jpRight.add(lbSelected);
        jpRight.add(this.scrollSelected);
        jpCenter.add(jpLeft);
        jpCenter.add(jpRight);
        northPanel.add((Component)jpCenter, "Center");
        JButton btCompare = new JButton("Compare");
        JButton btReset = new JButton("Reset");
        JButton btSave = new JButton("Save as");
        JPanel jpEast = new JPanel();
        jpEast.setLayout(new BoxLayout(jpEast, 1));
        jpEast.add(new JLabel(" "));
        jpEast.add(btCompare);
        jpEast.add(btReset);
        jpEast.add(btSave);
        northPanel.add((Component)jpEast, "East");
        this.getContentPane().add((Component)northPanel, "North");
        this.model = new DefaultTableModel();
        this.tbResult = new JTable(this.model);
        this.colName = new Vector();
        this.tableData = new Vector();
        JScrollPane jsResult = new JScrollPane(this.tbResult);
        this.tbResult.setDefaultRenderer(Object.class, new EvenOddRenderer());
        this.tbResult.setAutoCreateRowSorter(true);
        this.tbResult.setAutoscrolls(true);
        this.tbResult.setEnabled(false);
        this.getContentPane().add((Component)jsResult, "Center");
        this.colName.addElement("No.");
        this.colName.addElement("gene name");
        this.colName.addElement("circRNA ID");
        this.colName.addElement("chromosome");
        this.colName.addElement("donor site");
        this.colName.addElement("acceptor site");
        this.colName.addElement("junction reads");
        this.colName.addElement("strand");
        this.colName.addElement("tissue name");
        this.colName.addElement("tissue num");
        this.colName.addElement("sample name");
        this.colName.addElement("sample num");
        this.colName.addElement("tool name");
        this.colName.addElement("tool num");
        this.colName.addElement("circRNA type");
        this.colName.addElement("circRNA region");
        this.cbSpecies.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ComparisonFrame.this.unSelected.removeAllElements();
                    ComparisonFrame.this.selected.removeAllElements();
                    if (ComparisonFrame.this.cbSpecies.getSelectedItem() == null) {
                        return;
                    }
                    String species = ComparisonFrame.this.cbSpecies.getSelectedItem().toString();
                    TreeMap<String, String> tools = new TreeMap<String, String>();
                    for (Vector<String> rowData : MainData.getCircRnaFilesInfo()) {
                        String sname = rowData.get(0);
                        String fname = rowData.get(2);
                        if (!species.equalsIgnoreCase(sname)) continue;
                        tools.put(fname, fname);
                    }
                    for (String tool : tools.keySet()) {
                        ComparisonFrame.this.unSelected.add(tool);
                    }
                    ComparisonFrame.this.jlUnSelected.setListData(ComparisonFrame.this.unSelected);
                    ComparisonFrame.this.jlSelected.setListData(ComparisonFrame.this.selected);
                }
            }
        });
        this.jlUnSelected.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JList theList = (JList)e.getSource();
                int index = theList.locationToIndex(e.getPoint());
                if (index >= 0) {
                    String slct = (String)theList.getModel().getElementAt(index);
                    for (String name : ComparisonFrame.this.unSelected) {
                        if (!name.equalsIgnoreCase(slct)) continue;
                        ComparisonFrame.this.unSelected.remove(name);
                        break;
                    }
                    ComparisonFrame.this.selected.addElement(slct);
                    ComparisonFrame.this.jlUnSelected.removeAll();
                    ComparisonFrame.this.jlSelected.removeAll();
                    ComparisonFrame.this.jlUnSelected.setListData(ComparisonFrame.this.unSelected);
                    ComparisonFrame.this.jlSelected.setListData(ComparisonFrame.this.selected);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.jlSelected.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JList theList = (JList)e.getSource();
                int index = theList.locationToIndex(e.getPoint());
                if (index >= 0) {
                    String slct = (String)theList.getModel().getElementAt(index);
                    for (String name : ComparisonFrame.this.selected) {
                        if (!name.equalsIgnoreCase(slct)) continue;
                        ComparisonFrame.this.selected.remove(name);
                        break;
                    }
                    ComparisonFrame.this.unSelected.addElement(slct);
                    ComparisonFrame.this.jlUnSelected.removeAll();
                    ComparisonFrame.this.jlSelected.removeAll();
                    ComparisonFrame.this.jlUnSelected.setListData(ComparisonFrame.this.unSelected);
                    ComparisonFrame.this.jlSelected.setListData(ComparisonFrame.this.selected);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        btCompare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String species = (String)ComparisonFrame.this.cbSpecies.getSelectedItem();
                if (species == null || species.equals("")) {
                    return;
                }
                ComparisonFrame.this.fillTable();
            }
        });
        btReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComparisonFrame.this.unSelected.removeAllElements();
                ComparisonFrame.this.selected.removeAllElements();
                ComparisonFrame.this.jlUnSelected.setListData(ComparisonFrame.this.unSelected);
                ComparisonFrame.this.jlSelected.setListData(ComparisonFrame.this.selected);
                ComparisonFrame.this.tableData.removeAllElements();
                ComparisonFrame.this.model.setDataVector(ComparisonFrame.this.tableData, ComparisonFrame.this.colName);
            }
        });
        btSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CsvSaveFileChooser saveFile = new CsvSaveFileChooser("Save as ...");
                saveFile.setFileSelectionMode(0);
                saveFile.setMultiSelectionEnabled(false);
                int returnValue = saveFile.showSaveDialog(null);
                if (returnValue == 0) {
                    File fileOut = saveFile.getSelectedFile();
                    String type = "csv";
                    String fileName = String.valueOf(fileOut.getAbsolutePath()) + "." + type;
                    try {
                        BufferedWriter out = new BufferedWriter(new FileWriter(fileName));
                        int i = 0;
                        while (i < ComparisonFrame.this.tbResult.getColumnCount()) {
                            out.write(String.valueOf(ComparisonFrame.this.tbResult.getColumnName(i)) + "\t");
                            ++i;
                        }
                        out.newLine();
                        i = 0;
                        while (i < ComparisonFrame.this.tbResult.getRowCount()) {
                            int j = 0;
                            while (j < ComparisonFrame.this.tbResult.getColumnCount()) {
                                out.write(String.valueOf(ComparisonFrame.this.tbResult.getValueAt(i, j).toString()) + "\t");
                                ++j;
                            }
                            out.newLine();
                            ++i;
                        }
                        out.close();
                        JOptionPane.showMessageDialog(null, "Export Data Successfully!");
                    }
                    catch (IOException e1) {
                        CircView.log.warn((Object)e1.getMessage());
                    }
                }
            }
        });
        this.tbResult.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = ComparisonFrame.this.tbResult.rowAtPoint(e.getPoint());
                int col = ComparisonFrame.this.tbResult.columnAtPoint(e.getPoint());
                if (row >= 0 && col >= 0) {
                    Object value = ComparisonFrame.this.tbResult.getValueAt(row, col);
                    if (value != null && !value.equals("")) {
                        ComparisonFrame.this.tbResult.setToolTipText(value.toString());
                    } else {
                        ComparisonFrame.this.tbResult.setToolTipText(null);
                    }
                }
            }
        });
        for (String speciesName : MainData.getSpeciesData().keySet()) {
            this.cbSpecies.addItem(speciesName);
        }
        int i = 0;
        while (i <= 10) {
            this.cbTolerate.addItem(String.valueOf(i));
            ++i;
        }
    }

    private void fillTable() {
        this.tableData.removeAllElements();
        if (this.selected.size() > 0) {
            this.fillTableOr();
        }
        this.model.setDataVector(this.tableData, this.colName);
    }

    /*
     * WARNING - void declaration
     */
    private void fillTableOr() {
        int tolerate = Integer.parseInt((String)this.cbTolerate.getSelectedItem());
        int num = 0;
        String species = (String)this.cbSpecies.getSelectedItem();
        if (species == null || species.equals("")) {
            return;
        }
        TreeMap<String, Gene> genes = MainData.getSpeciesData().get(species);
        for (String geneName : genes.keySet()) {
            Gene gene = genes.get(geneName);
            TreeMap<String, GeneTranscript> geneTrans = gene.getGeneTranscripts();
            Iterator<String> iterator = geneTrans.keySet().iterator();
            if (!iterator.hasNext()) continue;
            String geneTransName = iterator.next();
            GeneTranscript gt = geneTrans.get(geneTransName);
            TreeMap<String, CircRna> circRnas = gt.getCircRnas();
            Vector<String> circIds = new Vector<String>();
            for (String circId : circRnas.keySet()) {
                circIds.addElement(circId);
            }
            TreeMap<String, Vector> matched = new TreeMap<String, Vector>();
            TreeMap<Integer, String> deleted = new TreeMap<Integer, String>();
            int i = 0;
            while (i < circIds.size() - 1) {
                int j = i + 1;
                while (j < circIds.size()) {
                    if (deleted.get(i) == null && deleted.get(j) == null) {
                        CircRna majorCirc = circRnas.get(circIds.get(i));
                        CircRna minorCirc = circRnas.get(circIds.get(j));
                        if (Math.abs(majorCirc.getStartPoint() - minorCirc.getStartPoint()) <= (long)tolerate && Math.abs(majorCirc.getEndPoint() - minorCirc.getEndPoint()) <= (long)tolerate) {
                            Vector sameCircs;
                            if (matched.get(majorCirc.getCircRnaID()) != null) {
                                sameCircs = (Vector)matched.get(majorCirc.getCircRnaID());
                                sameCircs.addElement(minorCirc.getCircRnaID());
                                matched.put(majorCirc.getCircRnaID(), sameCircs);
                                deleted.put(j, minorCirc.getCircRnaID());
                            } else {
                                sameCircs = new Vector();
                                sameCircs.addElement(minorCirc.getCircRnaID());
                                matched.put(majorCirc.getCircRnaID(), sameCircs);
                                deleted.put(j, minorCirc.getCircRnaID());
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < circIds.size()) {
                if (deleted.get(i) == null) {
                    String circId = (String)circIds.get(i);
                    TreeMap<String, Integer> files = new TreeMap<String, Integer>();
                    TreeMap<String, Integer> tissues = new TreeMap<String, Integer>();
                    TreeMap<String, Integer> samples = new TreeMap<String, Integer>();
                    TreeMap<String, Integer> tools = new TreeMap<String, Integer>();
                    for (String fileName : gt.getCircRnas().get(circId).getFiles().keySet()) {
                        files.put(fileName, 1);
                    }
                    for (String sampleName : gt.getCircRnas().get(circId).getSamples().keySet()) {
                        samples.put(sampleName, 1);
                    }
                    for (String toolName : gt.getCircRnas().get(circId).getCircTools().keySet()) {
                        tools.put(toolName, 1);
                    }
                    Vector sameCircs = (Vector)matched.get(circId);
                    if (sameCircs != null) {
                        for (String sameCircId : sameCircs) {
                            for (String fileName : gt.getCircRnas().get(sameCircId).getFiles().keySet()) {
                                files.put(fileName, 1);
                            }
                            for (String sampleName : gt.getCircRnas().get(sameCircId).getSamples().keySet()) {
                                samples.put(sampleName, 1);
                            }
                            for (String toolName : gt.getCircRnas().get(sameCircId).getCircTools().keySet()) {
                                tools.put(toolName, 1);
                            }
                        }
                    }
                    for (String sampleName : samples.keySet()) {
                        String[] tmp = sampleName.split("_");
                        tissues.put(tmp[0], 1);
                    }
                    TreeMap<String, Integer> fTissues = new TreeMap<String, Integer>();
                    TreeMap<String, Integer> fSamples = new TreeMap<String, Integer>();
                    TreeMap<String, Integer> fTools = new TreeMap<String, Integer>();
                    for (String name : this.selected) {
                        for (Vector<String> vector : MainData.getCircRnaFilesInfo()) {
                            String sname = vector.get(0);
                            String tname = vector.get(1);
                            String fname = vector.get(2);
                            if (!species.equalsIgnoreCase(sname) || !fname.equalsIgnoreCase(name)) continue;
                            String[] tmp = fname.split("_");
                            fTissues.put(tmp[0], 1);
                            tmp = fname.split("\\.");
                            fSamples.put(tmp[0], 1);
                            fTools.put(tname, 1);
                        }
                    }
                    boolean hasFile = false;
                    for (String name : files.keySet()) {
                        for (String file : this.selected) {
                            if (!file.equalsIgnoreCase(name)) continue;
                            hasFile = true;
                            break;
                        }
                        if (hasFile) break;
                    }
                    if (hasFile) {
                        void var28_35;
                        Vector<Object> one = new Vector<Object>();
                        one.addElement(String.valueOf(++num));
                        one.addElement(gene.getGeneName());
                        String string = circId;
                        if (sameCircs != null) {
                            int j = 0;
                            while (j < sameCircs.size()) {
                                void var28_37;
                                if (j == 0) {
                                    String string2 = String.valueOf(var28_35) + "(";
                                }
                                String string3 = String.valueOf(var28_37) + (String)sameCircs.get(j) + ",";
                                if (sameCircs.size() - 1 == j) {
                                    String string4 = String.valueOf(string3) + ")";
                                }
                                ++j;
                            }
                        }
                        one.addElement(var28_35);
                        one.addElement(gt.getCircRnas().get(circId).getChrom());
                        String startP = String.valueOf(gt.getCircRnas().get(circId).getStartPoint());
                        if (sameCircs != null) {
                            int j = 0;
                            while (j < sameCircs.size()) {
                                if (j == 0) {
                                    startP = String.valueOf(startP) + "(";
                                }
                                startP = String.valueOf(startP) + gt.getCircRnas().get(sameCircs.get(j)).getStartPoint() + ",";
                                if (sameCircs.size() - 1 == j) {
                                    startP = String.valueOf(startP) + ")";
                                }
                                ++j;
                            }
                        }
                        one.addElement(startP);
                        String endP = String.valueOf(gt.getCircRnas().get(circId).getEndPoint());
                        if (sameCircs != null) {
                            int j = 0;
                            while (j < sameCircs.size()) {
                                if (j == 0) {
                                    endP = String.valueOf(endP) + "(";
                                }
                                endP = String.valueOf(endP) + gt.getCircRnas().get(sameCircs.get(j)).getEndPoint() + ",";
                                if (sameCircs.size() - 1 == j) {
                                    endP = String.valueOf(endP) + ")";
                                }
                                ++j;
                            }
                        }
                        one.addElement(endP);
                        String reads = String.valueOf(gt.getCircRnas().get(circId).getJunctionReads());
                        if (sameCircs != null) {
                            int j = 0;
                            while (j < sameCircs.size()) {
                                if (j == 0) {
                                    reads = String.valueOf(reads) + "(";
                                }
                                reads = String.valueOf(reads) + gt.getCircRnas().get(sameCircs.get(j)).getJunctionReads() + ",";
                                if (sameCircs.size() - 1 == j) {
                                    reads = String.valueOf(reads) + ")";
                                }
                                ++j;
                            }
                        }
                        one.addElement(reads);
                        one.addElement(gt.getCircRnas().get(circId).getStrand());
                        String tissue = "";
                        int tissueNum = 0;
                        for (String tissueName : fTissues.keySet()) {
                            if (tissues.get(tissueName) == null) continue;
                            tissue = String.valueOf(tissue) + tissueName + ",";
                            ++tissueNum;
                        }
                        one.addElement(tissue);
                        one.addElement(String.valueOf(tissueNum));
                        String sample = "";
                        int sampleNum = 0;
                        for (String sampleName : fSamples.keySet()) {
                            if (samples.get(sampleName) == null) continue;
                            sample = String.valueOf(sample) + sampleName + ",";
                            ++sampleNum;
                        }
                        one.addElement(sample);
                        one.addElement(String.valueOf(sampleNum));
                        String tool = "";
                        int toolNum = 0;
                        for (String toolName : fTools.keySet()) {
                            if (tools.get(toolName) == null) continue;
                            tool = String.valueOf(tool) + toolName + ",";
                            ++toolNum;
                        }
                        one.addElement(tool);
                        one.addElement(String.valueOf(toolNum));
                        one.addElement(gt.getCircRnas().get(circId).getCircRnaType());
                        one.addElement(gt.getCircRnas().get(circId).getRegion());
                        this.tableData.addElement(one);
                    }
                }
                ++i;
            }
        }
    }
}

