/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.whu.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

public class DataLoadingProgressDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Timer timer;
    public static JProgressBar process;

    public DataLoadingProgressDialog(Frame owner, String title) {
        super(owner, title);
        this.setTitle(title);
        this.setResizable(false);
        this.setSize(300, 300);
        this.setLayout(new FlowLayout());
        this.centerScreen();
        this.initUI();
    }

    private void centerScreen() {
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
        super.setVisible(true);
        this.requestFocus();
    }

    private void initUI() {
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add(panel);
        process = new JProgressBar(0, 100);
        process.setStringPainted(true);
        process.setBackground(Color.GREEN);
        process.setPreferredSize(new Dimension(200, 40));
        process.setValue(0);
        panel.add(process);
        this.timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int loadingValue = process.getValue();
                if (loadingValue < 100) {
                    process.setValue(loadingValue);
                } else {
                    DataLoadingProgressDialog.this.timer.stop();
                }
            }
        });
        this.timer.start();
    }

    public static JProgressBar getProcess() {
        return process;
    }

    public static void setProcess(JProgressBar process) {
        DataLoadingProgressDialog.process = process;
    }
}

