/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.whu.ui;

import cn.edu.whu.CircView;
import cn.edu.whu.MainData;
import cn.edu.whu.ui.DataLoadingDialog;
import cn.edu.whu.util.DbUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class RbpClearDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    Connection conn;

    public RbpClearDialog(Connection conn) {
        super(CircView.frame);
        this.conn = conn;
        this.initUi();
        this.setTitle("Clear RBP Data");
        this.setResizable(false);
        this.setSize(300, 65);
        this.setLayout(new FlowLayout());
        this.centerScreen();
    }

    private void centerScreen() {
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
        super.setVisible(true);
        this.requestFocus();
    }

    private void initUi() {
        final JComboBox<String> cbSpecies = new JComboBox<String>();
        cbSpecies.setPreferredSize(new Dimension(150, 28));
        this.getContentPane().add(cbSpecies);
        cbSpecies.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                e.getStateChange();
            }
        });
        for (String speciesName : MainData.getSpeciesNames()) {
            cbSpecies.addItem(speciesName);
        }
        JButton btOpen = new JButton("Clear RBP Data");
        this.getContentPane().add(btOpen);
        btOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RbpClearDialog.this.setVisible(false);
                int dialogButton = JOptionPane.showConfirmDialog(CircView.frame, "All RBP Data for " + cbSpecies.getSelectedItem() + " WILL BE ERASE!");
                if (dialogButton == 0) {
                    DataLoadingDialog clearDialog = new DataLoadingDialog((Frame)CircView.frame, "Erasing RBP ...");
                    String species = cbSpecies.getSelectedItem().toString();
                    try {
                        String tableName = "rbp_" + DbUtil.species2TableName(species);
                        DbUtil.dropTable(RbpClearDialog.this.conn, tableName);
                    }
                    catch (ClassNotFoundException | SQLException ex) {
                        JOptionPane.showMessageDialog(CircView.frame, "RBP Data Clear Failed!");
                        CircView.log.warn((Object)ex.getMessage());
                    }
                    CircView.log.info((Object)("RBP Data for " + species + " Deleted"));
                    CircView.updateRbpMreStatus();
                    clearDialog.setVisible(false);
                }
                RbpClearDialog.this.dispose();
            }
        });
    }
}

