/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.whu.ui;

import cn.edu.whu.CircView;
import cn.edu.whu.MainData;
import cn.edu.whu.ui.DataLoadingDialog;
import cn.edu.whu.ui.OpenFileChooser;
import cn.edu.whu.util.DbUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class RbpLoadDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private File[] files;
    Connection conn;

    public RbpLoadDialog(Connection conn) {
        super(CircView.frame);
        this.conn = conn;
        this.initUi();
        this.setTitle("Load RBP files");
        this.setResizable(false);
        this.setSize(300, 65);
        this.setLayout(new FlowLayout());
        this.centerScreen();
    }

    private void centerScreen() {
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
        super.setVisible(true);
        this.requestFocus();
    }

    private void initUi() {
        final JComboBox<String> cbSpecies = new JComboBox<String>();
        cbSpecies.setPreferredSize(new Dimension(150, 28));
        this.getContentPane().add(cbSpecies);
        cbSpecies.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                e.getStateChange();
            }
        });
        for (String speciesName : MainData.getSpeciesNames()) {
            cbSpecies.addItem(speciesName);
        }
        JButton btOpen = new JButton("Open RBP files");
        this.getContentPane().add(btOpen);
        btOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RbpLoadDialog.this.setVisible(false);
                OpenFileChooser openFile = new OpenFileChooser("Open RBP Files");
                openFile.setMultiSelectionEnabled(true);
                openFile.setFileSelectionMode(0);
                openFile.setFileHidingEnabled(true);
                int returnValue = openFile.showOpenDialog(null);
                if (returnValue == 0) {
                    String species = cbSpecies.getSelectedItem().toString();
                    RbpLoadDialog.this.files = openFile.getSelectedFiles();
                    DataLoadingDialog dataLoadingDialog = new DataLoadingDialog((Frame)CircView.frame, "Loading RBP Data ...");
                    RbpLoadDialog.this.save2Db(species, RbpLoadDialog.this.files);
                    CircView.updateRbpMreStatus();
                    dataLoadingDialog.setVisible(false);
                }
                RbpLoadDialog.this.dispose();
            }
        });
    }

    private void save2Db(String species, File[] files) {
        if (this.conn == null) {
            try {
                this.conn = DbUtil.connectDb();
            }
            catch (ClassNotFoundException | SQLException e) {
                CircView.log.warn((Object)e.getMessage());
                JOptionPane.showConfirmDialog(CircView.frame, "Can't Connect to the Database!");
                return;
            }
        }
        try {
            String tableName = "rbp_" + DbUtil.species2TableName(species);
            if (!DbUtil.existTable(this.conn, tableName)) {
                DbUtil.createRbpTable(this.conn, tableName);
            }
            int i = 0;
            while (i < files.length) {
                DbUtil.file2Db(this.conn, files[i].getAbsolutePath(), tableName);
                ++i;
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            CircView.log.warn((Object)e.getMessage());
            JOptionPane.showMessageDialog(CircView.frame, "File FORMAT ERROR!");
        }
        CircView.log.info((Object)("RBP Data for " + species + " Loaded"));
    }
}

