/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.whu.ui;

import cn.edu.whu.CircView;
import cn.edu.whu.MainData;
import cn.edu.whu.ui.OpenFileChooser;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class SpeciesAddDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private File speciesFile;

    public SpeciesAddDialog() {
        super(CircView.frame);
        this.initUi();
        this.setTitle("Add Species");
        this.setResizable(false);
        this.setSize(600, 65);
        this.setLayout(new FlowLayout());
        this.centerScreen();
    }

    private void centerScreen() {
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
        super.setVisible(true);
        this.requestFocus();
    }

    private void initUi() {
        JLabel lbName = new JLabel("Name:");
        final JTextField tfSpecies = new JTextField();
        JLabel lbFile = new JLabel("");
        final JTextField tfFile = new JTextField();
        tfFile.setEditable(false);
        JButton btChoose = new JButton("Choose File");
        JButton btAdd = new JButton("Add");
        tfSpecies.setPreferredSize(new Dimension(100, 28));
        tfFile.setPreferredSize(new Dimension(150, 28));
        this.getContentPane().add(lbName);
        this.getContentPane().add(tfSpecies);
        this.getContentPane().add(lbFile);
        this.getContentPane().add(tfFile);
        this.getContentPane().add(btChoose);
        this.getContentPane().add(btAdd);
        btChoose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenFileChooser openFile = new OpenFileChooser("Select Gene Annotation File");
                openFile.setMultiSelectionEnabled(false);
                openFile.setFileSelectionMode(0);
                openFile.setFileHidingEnabled(true);
                int returnValue = openFile.showOpenDialog(null);
                if (returnValue == 0) {
                    tfFile.setText(openFile.getSelectedFile().getName());
                    SpeciesAddDialog.this.speciesFile = openFile.getSelectedFile();
                }
            }
        });
        btAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String pattern;
                String speciesName = tfSpecies.getText();
                if (speciesName.matches(pattern = "\\s+")) {
                    JOptionPane.showMessageDialog(CircView.frame, "Species Name is needed");
                    return;
                }
                if (SpeciesAddDialog.this.speciesFile == null || SpeciesAddDialog.this.speciesFile.getPath().matches(pattern)) {
                    JOptionPane.showMessageDialog(CircView.frame, "Annotation file for [" + speciesName + "] is needed");
                    return;
                }
                if (MainData.getSpeciesFile().get(speciesName) != null) {
                    JOptionPane.showMessageDialog(CircView.frame, "Species [" + speciesName + "] already exists");
                    return;
                }
                MainData.getSpeciesNames().add(speciesName);
                MainData.getSpeciesFile().put(speciesName, SpeciesAddDialog.this.speciesFile.getPath());
                CircView.log.error((Object)(String.valueOf(speciesName) + " " + SpeciesAddDialog.this.speciesFile.getPath() + " is added."));
                JOptionPane.showMessageDialog(CircView.frame, String.valueOf(speciesName) + " " + SpeciesAddDialog.this.speciesFile.getName() + " is added.");
                SpeciesAddDialog.this.dispose();
            }
        });
    }
}

