/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.whu.util;

import cn.edu.whu.CircView;
import cn.edu.whu.MainData;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DbUtil {
    public static Connection connectDb() throws ClassNotFoundException, SQLException {
        String server = MainData.getDbConfig().getDbServer();
        String port = MainData.getDbConfig().getDbPort();
        String user = MainData.getDbConfig().getDbUser();
        String passwd = MainData.getDbConfig().getDbPasswd();
        String url = "jdbc:mysql://" + server + ":" + port + "?" + "user=" + user + "&password=" + passwd;
        CircView.log.info((Object)url);
        Class.forName("com.mysql.jdbc.Driver");
        return DriverManager.getConnection(url);
    }

    public static void createDb(Connection conn) throws SQLException, ClassNotFoundException {
        if (conn == null || conn.isClosed()) {
            conn = DbUtil.connectDb();
        }
        String sql = "create database if not exists " + MainData.getDbConfig().getDbName();
        CircView.log.info((Object)sql);
        Statement st = conn.createStatement();
        st.executeUpdate(sql);
    }

    public static void useDb(Connection conn) throws ClassNotFoundException, SQLException {
        if (conn == null || conn.isClosed()) {
            conn = DbUtil.connectDb();
        }
        String sql = "use " + MainData.getDbConfig().getDbName();
        CircView.log.info((Object)sql);
        Statement st = conn.createStatement();
        st.executeUpdate(sql);
    }

    public static void createRbpTable(Connection conn, String table) throws SQLException, ClassNotFoundException {
        if (conn == null || conn.isClosed()) {
            conn = DbUtil.connectDb();
        }
        String sql = "create table " + table + " " + "(chr varchar(10), start int, end int, rbp varchar(512), detail varchar(1024))";
        CircView.log.info((Object)sql);
        Statement st = conn.createStatement();
        st.executeUpdate(sql);
    }

    public static void createMreTable(Connection conn, String table) throws SQLException, ClassNotFoundException {
        if (conn == null || conn.isClosed()) {
            conn = DbUtil.connectDb();
        }
        String sql = "create table " + table + " " + "(chr varchar(10), start int, end int, mre varchar(512), detail varchar(1024))";
        CircView.log.info((Object)sql);
        Statement st = conn.createStatement();
        st.executeUpdate(sql);
    }

    public static Vector<String> selectRbp(Connection conn, String table, String chrom, Vector<Long> starts, Vector<Long> ends) throws SQLException {
        if (starts.size() == 0) {
            CircView.log.info((Object)("There is no results from " + table));
            return null;
        }
        Vector<String> result = new Vector<String>();
        String sql = "select chr, start, end, rbp, detail from " + table + " where ";
        int i = 0;
        while (i < starts.size()) {
            sql = String.valueOf(sql) + "chr='" + chrom + "' and " + starts.get(i) + "<=start and end<=" + ends.get(i) + " or ";
            ++i;
        }
        sql = sql.substring(0, sql.length() - 3);
        CircView.log.info((Object)sql);
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            String chr = rs.getString(1);
            long start = rs.getInt(2);
            long end = rs.getInt(3);
            String rbp = rs.getString(4);
            String detail = rs.getString(5);
            result.addElement(String.valueOf(chr) + "\t" + start + "\t" + end + "\t" + rbp + "\t" + detail);
            CircView.log.info((Object)(String.valueOf(chr) + "\t" + start + "\t" + end + "\t" + rbp + "\t" + detail));
        }
        return result;
    }

    public static Vector<String> selectMre(Connection conn, String table, String chrom, Vector<Long> starts, Vector<Long> ends) throws SQLException {
        if (starts.size() == 0) {
            CircView.log.info((Object)("There is no results from " + table));
            return null;
        }
        Vector<String> result = new Vector<String>();
        String sql = "select chr, start, end, mre, detail from " + table + " where ";
        int i = 0;
        while (i < starts.size()) {
            sql = String.valueOf(sql) + "chr='" + chrom + "' and " + starts.get(i) + "<=start and end<=" + ends.get(i) + " or ";
            ++i;
        }
        sql = sql.substring(0, sql.length() - 3);
        CircView.log.info((Object)sql);
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            String chr = rs.getString(1);
            long start = rs.getInt(2);
            long end = rs.getInt(3);
            String rbp = rs.getString(4);
            String detail = rs.getString(5);
            result.addElement(String.valueOf(chr) + "\t" + start + "\t" + end + "\t" + rbp + "\t" + detail);
            CircView.log.info((Object)(String.valueOf(chr) + "\t" + start + "\t" + end + "\t" + rbp + "\t" + detail));
        }
        return result;
    }

    public static void file2Db(Connection conn, String fileName, String table) throws SQLException {
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            CircView.log.info((Object)"Running under Windows Operating System.");
            fileName = fileName.replaceAll("\\\\", "\\\\\\\\");
        }
        Statement st = conn.createStatement();
        String sql = "load data local infile '" + fileName + "' into table " + table + " fields terminated by '\t' lines terminated by '\n'";
        CircView.log.info((Object)sql);
        st.execute(sql);
    }

    public static void dropTable(Connection conn, String table) throws ClassNotFoundException, SQLException {
        if (conn == null || conn.isClosed()) {
            conn = DbUtil.connectDb();
        }
        String sql = "drop table " + table;
        CircView.log.info((Object)sql);
        Statement st = conn.createStatement();
        st.execute(sql);
    }

    public static void closeDb(Connection conn) throws SQLException {
        CircView.log.info((Object)"Database Closed");
        conn.close();
    }

    public static String species2TableName(String species) {
        String regex = "[\\W]+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(species);
        return matcher.replaceAll("_").trim();
    }

    public static boolean existTable(Connection conn, String tableName) throws ClassNotFoundException, SQLException {
        boolean ret = false;
        if (conn == null || conn.isClosed()) {
            conn = DbUtil.connectDb();
        }
        String sql = "show tables like '" + tableName + "'";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            ret = true;
        }
        return ret;
    }
}

